package ru.yandex.msearch.proxy.config;

import java.util.Map;

import ru.yandex.msearch.proxy.mail.SearchFilter;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class FiltersConfigBuilder
    extends AbstractFiltersConfigBuilder<FiltersConfigBuilder>
{
    private Map<String, SearchFilter> filters;

    public FiltersConfigBuilder() {
        this(FiltersConfigDefaults.INSTANCE);
    }

    public FiltersConfigBuilder(final FiltersConfig config) {
        super(config);
    }

    public FiltersConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, FiltersConfigDefaults.INSTANCE);
    }

    public FiltersConfigBuilder(
        final IniConfig config,
        final FiltersConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public FiltersConfigBuilder self() {
        return this;
    }

    public ImmutableFiltersConfig build() throws ConfigException {
        return new ImmutableFiltersConfig(this);
    }
}
