package ru.yandex.msearch.proxy.config;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.ImmutableFilterSearchConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableAsyncHttpServerBaseConfig
        extends ImmutableUniversalSearchProxyConfig
        implements AsyncHttpServerBaseConfig
{
    private final ImmutableFilterSearchConfig filterSearchConfig;
    private final ImmutableURIConfig foldersConfig;
    private final ImmutableTvm2ClientConfig filterSearchTvm2ClientConfig;
    private final ImmutableHttpHostConfig mopsClientConfig;
    private final ImmutableHttpHostConfig tupitaConfig;
    private final ImmutableHttpHostConfig furitaConfig;
    private final ImmutableHttpHostConfig producerStoreConfig;

    public ImmutableAsyncHttpServerBaseConfig(AsyncHttpServerBaseConfig config) throws ConfigException {
        super(config);
        filterSearchConfig = new ImmutableFilterSearchConfig(config.filterSearchConfig());
        foldersConfig = new ImmutableURIConfig(config.foldersConfig());
        filterSearchTvm2ClientConfig = new ImmutableTvm2ClientConfig(config.filterSearchTvm2ClientConfig());
        HttpHostConfig mopsClientConfig = config.mopsClientConfig();
        if (mopsClientConfig == null) {
            this.mopsClientConfig = null;
        } else {
            this.mopsClientConfig = new ImmutableHttpHostConfig(mopsClientConfig);
        }
        tupitaConfig = new ImmutableHttpHostConfig(config.tupitaConfig());
        furitaConfig = new ImmutableHttpHostConfig(config.furitaConfig());
        if (config.producerStoreConfig() != null) {
            producerStoreConfig = new ImmutableHttpHostConfig(config.producerStoreConfig());
        } else {
            producerStoreConfig = null;
        }
    }

    @Override
    public ImmutableFilterSearchConfig filterSearchConfig() {
        return filterSearchConfig;
    }

    @Override
    public ImmutableURIConfig foldersConfig() {
        return foldersConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig filterSearchTvm2ClientConfig() {
        return filterSearchTvm2ClientConfig;
    }

    @Override
    public ImmutableHttpHostConfig mopsClientConfig() {
        return mopsClientConfig;
    }

    @Override
    public ImmutableHttpHostConfig tupitaConfig() {
        return tupitaConfig;
    }

    @Override
    public ImmutableHttpHostConfig furitaConfig() {
        return furitaConfig;
    }

    @Override
    public ImmutableHttpHostConfig producerStoreConfig() {
        return producerStoreConfig;
    }
}
