package ru.yandex.msearch.proxy.config;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;

public class ImmutableChemodanConfig
     implements ChemodanConfig
{
    private final String webattachUrl;
    private final String corpWebattachUrl;
    private final int webattachTtl;
    private final Set<String> previewableExtensions;
    private final boolean ps3183Shield;

    public ImmutableChemodanConfig(
        final ChemodanConfig config)
        throws ConfigException
    {
        this.webattachUrl = config.webattachUrl();
        this.corpWebattachUrl = config.corpWebattachUrl();
        this.webattachTtl = config.webattachTtl();
        this.previewableExtensions =
            Collections.unmodifiableSet(
                new LinkedHashSet<>(
                    config.previewableExtensions()));
        this.ps3183Shield = config.ps3183Shield();
    }

    @Override
    public String webattachUrl() {
        return webattachUrl;
    }

    @Override
    public String corpWebattachUrl() {
        return corpWebattachUrl;
    }

    @Override
    public int webattachTtl() {
        return webattachTtl;
    }

    @Override
    public Set<String> previewableExtensions() {
        return previewableExtensions;
    }

    @Override
    public boolean ps3183Shield() {
        return ps3183Shield;
    }
}
