package ru.yandex.msearch.proxy.config;

public class ImmutableContactSuggestConfig implements ContactSuggestConfig {
    private final int maxRequestTime;
    private final int limit;
    private final int printkeysCacheSize;
    private final int printkeysCacheExpire;
    private final int reservedSize;
    private final int sendersFastRequestThreshold;
    private final int printKeysLimit;

    private final boolean enabled;
    private final boolean showOnEmptyRequest;
    private final boolean sendersEnabled;

    public ImmutableContactSuggestConfig(final ContactSuggestConfig config) {
        this.maxRequestTime = config.maxRequestTime();
        this.limit = config.limit();
        this.enabled = config.enabled();
        this.printkeysCacheSize = config.printkeysCacheSize();
        this.printkeysCacheExpire = config.printkeysCacheExpire();
        this.reservedSize = config.reservedSize();
        this.showOnEmptyRequest = config.showOnEmptyRequest();
        this.sendersFastRequestThreshold = config.sendersFastRequestThreshold();
        this.sendersEnabled = config.sendersEnabled();
        this.printKeysLimit = config.printkeysLimit();
    }

    @Override
    public int maxRequestTime() {
        return maxRequestTime;
    }

    @Override
    public int limit() {
        return limit;
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public int printkeysCacheSize() {
        return printkeysCacheSize;
    }

    @Override
    public int printkeysCacheExpire() {
        return printkeysCacheExpire;
    }

    @Override
    public int reservedSize() {
        return reservedSize;
    }

    @Override
    public boolean showOnEmptyRequest() {
        return showOnEmptyRequest;
    }

    @Override
    public boolean sendersEnabled() {
        return sendersEnabled;
    }

    @Override
    public int sendersFastRequestThreshold() {
        return sendersFastRequestThreshold;
    }

    @Override
    public int printkeysLimit() {
        return printKeysLimit;
    }
}
