package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableDkimStatsConfig
    implements DkimStatsConfig, ImmutableConfig
{
    private final Long failoverDelay;
    private final long cacheTtl;
    private final long cacheCapacity;
    private final int updateConcurrency;
    private final long retryInterval;

    public ImmutableDkimStatsConfig(final DkimStatsConfig config)
        throws ConfigException
    {
        failoverDelay = FAILOVER_DELAY.validate(config.failoverDelay());
        cacheTtl = CACHE_TTL.validate(config.cacheTtl());
        cacheCapacity = CACHE_CAPACITY.validate(config.cacheCapacity());
        updateConcurrency =
            UPDATE_CONCURRENCY.validate(config.updateConcurrency());
        retryInterval = RETRY_INTERVAL.validate(config.retryInterval());
    }

    @Override
    public Long failoverDelay() {
        return failoverDelay;
    }

    @Override
    public long cacheTtl() {
        return cacheTtl;
    }

    @Override
    public long cacheCapacity() {
        return cacheCapacity;
    }

    @Override
    public int updateConcurrency() {
        return updateConcurrency;
    }

    @Override
    public long retryInterval() {
        return retryInterval;
    }
}

