package ru.yandex.msearch.proxy.config;

import java.util.Collections;
import java.util.Map;

import ru.yandex.msearch.proxy.api.async.enlarge.Enlargeble;

public class ImmutableEnlargeConfig implements EnlargeConfig {
    private Map<String, Enlargeble> enlargebles;

    public ImmutableEnlargeConfig(final EnlargeConfig config) {
        this.enlargebles = Collections.unmodifiableMap(config.enlargebles());
    }

    @Override
    public Map<String, Enlargeble> enlargebles() {
        return enlargebles;
    }
}
