package ru.yandex.msearch.proxy.config;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableFactorsLogConfig
    extends ImmutableLoggerConfig
    implements FactorsLogConfig
{
    private final Set<String> factors;
    private final boolean personal;

    public ImmutableFactorsLogConfig(
        final FactorsLogConfig config)
        throws ConfigException
    {
        super(config);

        this.factors = new LinkedHashSet<>(config.factors());
        this.personal = config.personal();
    }

    @Override
    public Set<String> factors() {
        return factors;
    }

    @Override
    public boolean personal() {
        return personal;
    }
}
