package ru.yandex.msearch.proxy.config;

import java.util.Collections;
import java.util.Map;

import ru.yandex.msearch.proxy.mail.SearchFilter;

public class ImmutableFiltersConfig implements FiltersConfig {
    private Map<String, SearchFilter> filters;

    public ImmutableFiltersConfig(final FiltersConfig config) {
        this.filters = Collections.unmodifiableMap(config.filters());
    }

    @Override
    public Map<String, SearchFilter> filters() {
        return filters;
    }
}
