package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;

public class ImmutableMailSuggestConfig
     implements MailSuggestConfig
{
    private final String mailSuggestRelevanceModel;
    private final int minSymbols;
    private final int count;
    private final int minSymbolsExp;

    public ImmutableMailSuggestConfig(
        final MailSuggestConfig config)
        throws ConfigException
    {
        this.mailSuggestRelevanceModel = config.mailSuggestRelevanceModel();
        this.minSymbols = config.minSymbols();
        this.count = config.count();
        this.minSymbolsExp = config.minSymbolsExp();
    }

    @Override
    public String mailSuggestRelevanceModel() {
        return mailSuggestRelevanceModel;
    }

    @Override
    public int minSymbols() {
        return minSymbols;
    }

    @Override
    public int count() {
        return count;
    }

    @Override
    public int minSymbolsExp() {
        return minSymbolsExp;
    }
}
