package ru.yandex.msearch.proxy.config;

import java.util.regex.Pattern;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.erratum.ErratumConfig;
import ru.yandex.erratum.ImmutableErratumConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.ImmutableFilterSearchConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.msearch.proxy.api.async.mail.classification.ImmutableClassificationConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.passport.search.config.ImmutableMultisearchConfig;
import ru.yandex.search.msal.pool.ImmutableAddressPgConfig;
import ru.yandex.search.msal.pool.ImmutablePoolConfig;
import ru.yandex.stater.ImmutableStaterConfig;

public class ImmutableMsearchProxyConfig
    extends ImmutableAsyncHttpServerBaseConfig
    implements MsearchProxyConfig
{
    private final ImmutableLoggerConfig errorLogConfig;
    private final ImmutableFactorsLogConfig tskvLogConfig;
    private final ImmutableFilterSearchConfig filterSearchConfig;
    private final ImmutableFilterSearchConfig threadsConfig;
    private final ImmutableURIConfig labelsConfig;
    private final ImmutableURIConfig foldersConfig;
    private final ImmutableHttpTargetConfig proxyConfig;
    private final ImmutableFilterSearchConfig corpFilterSearchConfig;
    private final ImmutableURIConfig corpLabelsConfig;
    private final ImmutableURIConfig corpFoldersConfig;
    private final ImmutableHttpHostConfig blackboxConfig;
    private final ImmutableTvm2ClientConfig blackboxTvm2ClientConfig;
    private final ImmutableHttpHostConfig corpBlackboxConfig;
    private final ImmutableTvm2ClientConfig corpBlackboxTvm2ClientConfig;
    private final ImmutableTvm2ClientConfig corpFilterSearchTvm2ClientConfig;
    private final ImmutableTvm2ClientConfig filterSearchTvm2ClientConfig;
    private final ImmutableHttpHostConfig userSplitConfig;
    private final ImmutableHttpHostConfig corpMlConfig;
    private final ImmutableHttpHostConfig iexProxyConfig;
    private final ImmutableHttpHostConfig producerStoreConfig;
    private final ImmutableHttpHostConfig mopsClientConfig;
    private final ImmutableFiltersConfig filtersConfig;
    private final ImmutableEnlargeConfig enlargeConfig;
    private final ImmutableStaterConfig backendsResponsesStaterConfig;
    private final ImmutableStaterConfig filterSearchResponsesStaterConfig;
    private final ImmutableStaterConfig
    searchBackendsResolveResponsesStaterConfig;
    private final ImmutableStaterConfig searchFilterMailSearchStaterConfig;
    private final ImmutableSoCheckConfig soCheckConfig;
    private final ImmutableErratumConfig erratumConfig;
    private final ImmutableSuggestConfig suggestConfig;
    private final ImmutableRankingConfig rankingConfig;
    private final ImmutableSubscriptionsConfig subscriptionsConfig;
    private final ImmutableClassificationConfig classificationConfig;
    private final ImmutableChemodanConfig chemodanConfig;
    private final Pattern forbiddenRequests;
    private final boolean pureSearch;
    private final boolean indexSearchRequests;
    private final boolean queryLanguage;
    private final boolean topRelevant;
    private final String pgQueue;
    private final String pgCorpQueue;
    private final String oracleQueue;
    private final String oracleCorpQueue;
    private final long failoverSearchDelay;
    private final long sendersFailoverDelay;
    private final int syncServerThreads;
    private final int syncServerQueueSize;
    private final int maxExpectedSearchBackends;
    private final ImmutableHttpTargetConfig keyboardBackendConfig;
    private final String keyboardOAuthScope;
    private final ImmutableDkimStatsConfig dkimStatsConfig;
    private final ImmutableHttpHostConfig tupitaConfig;
    private final ImmutableHttpHostConfig furitaConfig;
    private final ImmutableMultisearchConfig multisearchConfig;
    private final ImmutableAddressPgConfig pgPoolConfig;

    public ImmutableMsearchProxyConfig(final MsearchProxyConfig config)
        throws ConfigException
    {
        super(config);
        forceTvm2ServiceConfig();

        errorLogConfig = new ImmutableLoggerConfig(config.errorLogConfig());

        filterSearchConfig =
            new ImmutableFilterSearchConfig(config.filterSearchConfig());
        threadsConfig =
            new ImmutableFilterSearchConfig(config.threadsConfig());

        labelsConfig = new ImmutableURIConfig(config.labelsConfig());
        foldersConfig = new ImmutableURIConfig(config.foldersConfig());
        corpFilterSearchConfig =
            new ImmutableFilterSearchConfig(config.corpFilterSearchConfig());
        corpLabelsConfig = new ImmutableURIConfig(config.corpLabelsConfig());
        corpFoldersConfig = new ImmutableURIConfig(config.corpFoldersConfig());
        blackboxConfig = new ImmutableHttpHostConfig(config.blackboxConfig());
        blackboxTvm2ClientConfig =
            new ImmutableTvm2ClientConfig(config.blackboxTvm2ClientConfig());
        corpBlackboxConfig =
            new ImmutableHttpHostConfig(config.corpBlackboxConfig());
        corpBlackboxTvm2ClientConfig = new ImmutableTvm2ClientConfig(
            config.corpBlackboxTvm2ClientConfig());
        filterSearchTvm2ClientConfig = new ImmutableTvm2ClientConfig(
            config.filterSearchTvm2ClientConfig());
        corpFilterSearchTvm2ClientConfig = new ImmutableTvm2ClientConfig(
            config.corpFilterSearchTvm2ClientConfig());
        filtersConfig = new ImmutableFiltersConfig(config.filtersConfig());
        enlargeConfig = new ImmutableEnlargeConfig(config.enlargeConfig());
        backendsResponsesStaterConfig =
            new ImmutableStaterConfig(config.backendsResponsesStaterConfig());
        filterSearchResponsesStaterConfig = new ImmutableStaterConfig(
            config.filterSearchResponsesStaterConfig());
        searchBackendsResolveResponsesStaterConfig = new ImmutableStaterConfig(
            config.searchBackendsResolveResponsesStaterConfig());

        searchFilterMailSearchStaterConfig =
            new ImmutableStaterConfig(
                config.searchFilterMailSearchStaterConfig());

        classificationConfig =
            new ImmutableClassificationConfig(config.classificationConfig());
        chemodanConfig = new ImmutableChemodanConfig(config.chemodanConfig());

        proxyConfig = new ImmutableHttpTargetConfig(config.proxyConfig());
        if (config.producerStoreConfig() != null) {
            this.producerStoreConfig =
                new ImmutableHttpHostConfig(config.producerStoreConfig());
        } else {
            this.producerStoreConfig = null;
        }

        if (config.tskvLogConfig() != null) {
            tskvLogConfig =
                new ImmutableFactorsLogConfig(config.tskvLogConfig());
        } else {
            tskvLogConfig = null;
        }

        SoCheckConfig soCheckConfig = config.soCheckConfig();
        if (soCheckConfig == null) {
            this.soCheckConfig = null;
        } else {
            this.soCheckConfig = new ImmutableSoCheckConfig(soCheckConfig);
        }

        ErratumConfig erratumConfig = config.erratumConfig();
        if (erratumConfig == null) {
            this.erratumConfig = null;
        } else {
            this.erratumConfig = new ImmutableErratumConfig(erratumConfig);
        }

        this.suggestConfig = new ImmutableSuggestConfig(config.suggestConfig());

        HttpHostConfig userSplitConfig = config.userSplitConfig();
        if (userSplitConfig == null) {
            this.userSplitConfig = null;
        } else {
            this.userSplitConfig = new ImmutableHttpHostConfig(userSplitConfig);
        }

        HttpHostConfig iexProxyConfig = config.iexProxyConfig();
        if (iexProxyConfig == null) {
            this.iexProxyConfig = null;
        } else {
            this.iexProxyConfig = new ImmutableHttpHostConfig(iexProxyConfig);
        }

        HttpHostConfig mopsClientConfig = config.mopsClientConfig();
        if (mopsClientConfig == null) {
            this.mopsClientConfig = null;
        } else {
            this.mopsClientConfig = new ImmutableHttpHostConfig(mopsClientConfig);
        }

        if (config.multisearchConfig() != null) {
            multisearchConfig = new ImmutableMultisearchConfig(config.multisearchConfig());
        } else {
            multisearchConfig = null;
        }

        this.rankingConfig
                = new ImmutableRankingConfig(config.rankingConfig());

        this.subscriptionsConfig =
            new ImmutableSubscriptionsConfig(config.subscriptionsConfig());

        forbiddenRequests = config.forbiddenRequests();
        pureSearch = config.pureSearch();
        indexSearchRequests = config.indexSearchRequests();
        queryLanguage = config.queryLanguage();
        topRelevant = config.topRelevant();

        pgQueue = PG_QUEUE.validate(config.pgQueue());
        pgCorpQueue = PG_CORP_QUEUE.validate(config.pgCorpQueue());
        oracleQueue = ORACLE_QUEUE.validate(config.oracleQueue());
        oracleCorpQueue = ORACLE_CORP_QUEUE.validate(config.oracleCorpQueue());
        failoverSearchDelay =
            FAILOVER_SEARCH_DELAY.validate(config.failoverSearchDelay());
        sendersFailoverDelay =
            SENDERS_FAILOVER_DELAY.validate(config.sendersFailoverDelay());
        syncServerThreads =
            SYNC_SERVER_THREADS.validate(config.syncServerThreads());
        syncServerQueueSize =
            SYNC_SERVER_QUEUE_SIZE.validate(config.syncServerQueueSize());
        maxExpectedSearchBackends = MAX_EXPECTED_SEARCH_BACKENDS.validate(
            config.maxExpectedSearchBackends());

        keyboardBackendConfig =
            new ImmutableHttpTargetConfig(config.keyboardBackendConfig());
        keyboardOAuthScope =
            KEYBOARD_OAUTH_SCOPE.validate(config.keyboardOAuthScope());
        corpMlConfig = new ImmutableHttpHostConfig(config.corpMlConfig());

        dkimStatsConfig = DKIM_STATS_CONFIG.validate(config.dkimStatsConfig());
        tupitaConfig = new ImmutableHttpHostConfig(config.tupitaConfig());
        furitaConfig = new ImmutableHttpHostConfig(config.furitaConfig());

        if (config.pgPoolConfig() != null) {
            pgPoolConfig = new ImmutableAddressPgConfig(config.pgPoolConfig());
        } else {
            pgPoolConfig = null;
        }
    }

    @Override
    public ImmutableSubscriptionsConfig subscriptionsConfig() {
        return subscriptionsConfig;
    }

    @Override
    public ImmutableLoggerConfig errorLogConfig() {
        return errorLogConfig;
    }

    @Override
    public ImmutableFilterSearchConfig filterSearchConfig() {
        return filterSearchConfig;
    }

    @Override
    public ImmutableFilterSearchConfig threadsConfig() {
        return threadsConfig;
    }

    @Override
    public ImmutableURIConfig labelsConfig() {
        return labelsConfig;
    }

    @Override
    public ImmutableURIConfig foldersConfig() {
        return foldersConfig;
    }

    @Override
    public ImmutableFilterSearchConfig corpFilterSearchConfig() {
        return corpFilterSearchConfig;
    }

    @Override
    public ImmutableURIConfig corpLabelsConfig() {
        return corpLabelsConfig;
    }

    @Override
    public ImmutableURIConfig corpFoldersConfig() {
        return corpFoldersConfig;
    }

    @Override
    public ImmutableHttpHostConfig blackboxConfig() {
        return blackboxConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig blackboxTvm2ClientConfig() {
        return blackboxTvm2ClientConfig;
    }

    @Override
    public ImmutableHttpHostConfig corpBlackboxConfig() {
        return corpBlackboxConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig corpBlackboxTvm2ClientConfig() {
        return corpBlackboxTvm2ClientConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig filterSearchTvm2ClientConfig() {
        return filterSearchTvm2ClientConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig corpFilterSearchTvm2ClientConfig() {
        return corpFilterSearchTvm2ClientConfig;
    }

    @Override
    public ImmutableFiltersConfig filtersConfig() {
        return filtersConfig;
    }

    @Override
    public ImmutableEnlargeConfig enlargeConfig() {
        return enlargeConfig;
    }

    @Override
    public ImmutableStaterConfig backendsResponsesStaterConfig() {
        return backendsResponsesStaterConfig;
    }

    @Override
    public ImmutableStaterConfig filterSearchResponsesStaterConfig() {
        return filterSearchResponsesStaterConfig;
    }

    @Override
    public ImmutableStaterConfig searchBackendsResolveResponsesStaterConfig() {
        return searchBackendsResolveResponsesStaterConfig;
    }

    @Override
    public ImmutableSoCheckConfig soCheckConfig() {
        return soCheckConfig;
    }

    @Override
    public ImmutableSuggestConfig suggestConfig() {
        return suggestConfig;
    }

    @Override
    public ImmutableErratumConfig erratumConfig() {
        return erratumConfig;
    }

    @Override
    public ImmutableHttpHostConfig userSplitConfig() {
        return userSplitConfig;
    }

    @Override
    public ImmutableHttpHostConfig corpMlConfig() {
        return corpMlConfig;
    }

    @Override
    public ImmutableHttpHostConfig iexProxyConfig() {
        return iexProxyConfig;
    }

    @Override
    public Pattern forbiddenRequests() {
        return forbiddenRequests;
    }

    @Override
    public boolean pureSearch() {
        return pureSearch;
    }

    @Override
    public boolean indexSearchRequests() {
        return indexSearchRequests;
    }

    @Override
    public boolean queryLanguage() {
        return queryLanguage;
    }

    @Override
    public boolean topRelevant() {
        return topRelevant;
    }

    @Override
    public String pgQueue() {
        return pgQueue;
    }

    @Override
    public String pgCorpQueue() {
        return pgCorpQueue;
    }

    @Override
    public String oracleQueue() {
        return oracleQueue;
    }

    @Override
    public String oracleCorpQueue() {
        return oracleCorpQueue;
    }

    @Override
    public long failoverSearchDelay() {
        return failoverSearchDelay;
    }

    @Override
    public long sendersFailoverDelay() {
        return sendersFailoverDelay;
    }

    @Override
    public int syncServerThreads() {
        return syncServerThreads;
    }

    @Override
    public int syncServerQueueSize() {
        return syncServerQueueSize;
    }

    @Override
    public int maxExpectedSearchBackends() {
        return maxExpectedSearchBackends;
    }

    @Override
    public ImmutableFactorsLogConfig tskvLogConfig() {
        return tskvLogConfig;
    }

    @Override
    public ImmutableRankingConfig rankingConfig() {
        return rankingConfig;
    }

    @Override
    public ImmutableHttpTargetConfig proxyConfig() {
        return proxyConfig;
    }

    @Override
    public ImmutableHttpHostConfig producerStoreConfig() {
        return producerStoreConfig;
    }

    @Override
    public ImmutableHttpTargetConfig keyboardBackendConfig() {
        return keyboardBackendConfig;
    }

    @Override
    public String keyboardOAuthScope() {
        return keyboardOAuthScope;
    }

    @Override
    public ImmutableClassificationConfig classificationConfig() {
        return classificationConfig;
    }

    @Override
    public ImmutableStaterConfig searchFilterMailSearchStaterConfig() {
        return searchFilterMailSearchStaterConfig;
    }

    @Override
    public ImmutableChemodanConfig chemodanConfig() {
        return chemodanConfig;
    }

    @Override
    public ImmutableDkimStatsConfig dkimStatsConfig() {
        return dkimStatsConfig;
    }

    @Override
    public ImmutableHttpHostConfig mopsClientConfig() {
        return mopsClientConfig;
    }

    @Override
    public ImmutableHttpHostConfig tupitaConfig() {
        return tupitaConfig;
    }

    @Override
    public ImmutableHttpHostConfig furitaConfig() {
        return furitaConfig;
    }

    @Override
    public ImmutableMultisearchConfig multisearchConfig() {
        return multisearchConfig;
    }

    @Override
    public ImmutableAddressPgConfig pgPoolConfig() {
        return pgPoolConfig;
    }
}

