package ru.yandex.msearch.proxy.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.ImmutableMailSearchRelevanceConfig;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.MailSearchRelevanceConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableRankingConfig implements RankingConfig {
    private final List<ImmutableMailSearchRelevanceConfig> mailSearch;
    private final boolean rankEmailRequests;
    private final Set<String> excludedExperiments;

    public ImmutableRankingConfig(final RankingConfig config)
        throws ConfigException
    {
        List<ImmutableMailSearchRelevanceConfig> mailSearch = new ArrayList<>();
        if (config.mailSearch() != null) {
            for (MailSearchRelevanceConfig rankConfig : config.mailSearch()) {
                mailSearch.add(
                    new ImmutableMailSearchRelevanceConfig(rankConfig));
            }
        }

        this.mailSearch = Collections.unmodifiableList(mailSearch);
        this.rankEmailRequests = config.rankEmailRequests();
        this.excludedExperiments =
            Collections.unmodifiableSet(config.excludedExperiments());
    }

    @Override
    public List<? extends ImmutableMailSearchRelevanceConfig> mailSearch() {
        return mailSearch;
    }

    @Override
    public boolean rankEmailRequests() {
        return rankEmailRequests;
    }

    @Override
    public Set<String> excludedExperiments() {
        return excludedExperiments;
    }
}
