package ru.yandex.msearch.proxy.config;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.matrixnet.ImmutableMatrixnetModelConfig;
import ru.yandex.msearch.proxy.api.async.mail.Product;
import ru.yandex.msearch.proxy.api.async.mail.Side;
import ru.yandex.parser.config.ConfigException;

public class ImmutableRelevanceConfig
    extends ImmutableMatrixnetModelConfig
    implements RelevanceConfig
{
    public static final String DEFAULT = "default";

    private final Set<Product> products;
    private final Set<Side> sides;
    private final Set<String> factors;
    private final String testId;
    private final RelevanceUsageStatus usageStatus;

    public ImmutableRelevanceConfig(
        final RelevanceConfig config)
        throws ConfigException
    {
        super(config);

        products = Collections.unmodifiableSet(config.products());
        sides = Collections.unmodifiableSet(config.sides());
        factors = new LinkedHashSet<>(config.factors());
        testId = config.testId();

        usageStatus = config.usageStatus();

        if (usageStatus == RelevanceUsageStatus.EXPERIMENT && testId == null) {
            throw new ConfigException("Experiment have null test id");
        }
    }

    @Override
    public String testId() {
        return testId;
    }

    @Override
    public Set<Product> products() {
        return products;
    }

    @Override
    public Set<Side> sides() {
        return sides;
    }

    @Override
    public RelevanceUsageStatus usageStatus() {
        return usageStatus;
    }

    @Override
    public Set<String> factors() {
        return factors;
    }
}
