package ru.yandex.msearch.proxy.config;

import java.net.URI;

import ru.yandex.http.config.ImmutableURIConfig;

import ru.yandex.parser.config.ConfigException;

public class ImmutableSoCheckConfig
    extends ImmutableURIConfig
    implements SoCheckConfig
{
    private final boolean banSpam;
    private final String fakeRequest;
    private final long fakeRequestInterval;

    public ImmutableSoCheckConfig(final SoCheckConfig config)
        throws ConfigException
    {
        super(config);
        banSpam = config.banSpam();
        fakeRequest = config.fakeRequest();
        fakeRequestInterval = config.fakeRequestInterval();
    }

    @Override
    public boolean banSpam() {
        return banSpam;
    }

    @Override
    public String fakeRequest() {
        return fakeRequest;
    }

    @Override
    public long fakeRequestInterval() {
        return fakeRequestInterval;
    }
}

