package ru.yandex.msearch.proxy.config;

public class ImmutableSubjectSuggestConfig implements SubjectSuggestConfig {
    private final boolean enabled;
    private final int limit;
    private final boolean responseonEmptyRequest;
    private final int subjectMinimumWordLength;
    private final int minimumRequestLenToMorpho;
    private final int minimumRequestStoreLen;

    public ImmutableSubjectSuggestConfig(final SubjectSuggestConfig config) {
        this.enabled = config.enabled();
        this.limit = config.limit();
        this.responseonEmptyRequest = config.responseOnEmpty();
        this.subjectMinimumWordLength = config.subjectMinimumWordLength();
        this.minimumRequestLenToMorpho = config.minimumRequestLenToMorpho();
        this.minimumRequestStoreLen = config.minimumRequestStoreLen();
    }

    @Override
    public int limit() {
        return limit;
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public boolean responseOnEmpty() {
        return responseonEmptyRequest;
    }

    @Override
    public int subjectMinimumWordLength() {
        return subjectMinimumWordLength;
    }

    @Override
    public int minimumRequestLenToMorpho() {
        return minimumRequestLenToMorpho;
    }

    @Override
    public int minimumRequestStoreLen() {
        return minimumRequestStoreLen;
    }
}
