package ru.yandex.msearch.proxy.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.email.types.MessageType;

public class ImmutableSubscriptionsConfig
    extends ImmutableHttpTargetConfig
    implements SubscriptionsConfig
{
    private final int minMailsInSubcscriptions;
    private final List<MessageType> messageTypes;
    private final int timeout;
    private final int minimalMailAge;
    private final File pinnedDisplayNames;
    private final long failoverDelay;

    public ImmutableSubscriptionsConfig(
        final SubscriptionsConfig config)
        throws ConfigException
    {
        super(config);

        this.messageTypes = new ArrayList<>(config.messageTypes());
        this.minMailsInSubcscriptions = config.minMailsInSubcscriptions();
        this.timeout = config.timeout();
        this.minimalMailAge = config.minimalMailAge();
        this.pinnedDisplayNames = config.pinnedDisplayNames();
        this.failoverDelay = config.failoverDelay();
    }

    @Override
    public int minMailsInSubcscriptions() {
        return minMailsInSubcscriptions;
    }

    @Override
    public List<MessageType> messageTypes() {
        return messageTypes;
    }

    @Override
    public int timeout() {
        return timeout;
    }

    @Override
    public int minimalMailAge() {
        return minimalMailAge;
    }

    @Override
    public File pinnedDisplayNames() {
        return pinnedDisplayNames;
    }

    @Override
    public long failoverDelay() {
        return failoverDelay;
    }
}
