package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class MailSuggestConfigBuilder
     extends AbstractMailSuggestConfigBuilder<MailSuggestConfigBuilder>
{
    public MailSuggestConfigBuilder() {
        this(MailSuggestConfigDefaults.INSTANCE);
    }

    public MailSuggestConfigBuilder(final MailSuggestConfig config) {
        super(config);
    }

    public MailSuggestConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, MailSuggestConfigDefaults.INSTANCE);
    }

    public MailSuggestConfigBuilder(
        final IniConfig config,
        final MailSuggestConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableMailSuggestConfig build() throws ConfigException {
        return new ImmutableMailSuggestConfig(
            this);
    }

    @Override
    public MailSuggestConfigBuilder self() {
        return this;
    }
}
