package ru.yandex.msearch.proxy.config;

import java.util.regex.Pattern;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.erratum.ErratumConfig;
import ru.yandex.http.config.FilterSearchConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.URIConfig;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.msearch.proxy.api.async.mail.classification.ClassificationConfig;
import ru.yandex.parser.config.NullableSectionConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;
import ru.yandex.passport.search.config.MultisearchConfig;
import ru.yandex.search.msal.pool.AddressPgConfig;
import ru.yandex.search.msal.pool.PoolConfig;
import ru.yandex.stater.StaterConfig;

public interface MsearchProxyConfig extends AsyncHttpServerBaseConfig {
    ParameterConfig<String> PG_QUEUE =
        new ParameterConfig<>("pg-queue", x -> x, NonEmptyValidator.INSTANCE);
    ParameterConfig<String> PG_CORP_QUEUE = new ParameterConfig<>(
        "pg-corp-queue",
        x -> x,
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> ORACLE_QUEUE = new ParameterConfig<>(
        "oracle-queue",
        x -> x,
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> ORACLE_CORP_QUEUE = new ParameterConfig<>(
        "oracle-corp-queue",
        x -> x,
        NonEmptyValidator.INSTANCE);
    ParameterConfig<Long> FAILOVER_SEARCH_DELAY = new ParameterConfig<>(
        SEARCH_SECTION + ".failover-delay",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        NonNegativeValidator.instance());
    ParameterConfig<Long> SENDERS_FAILOVER_DELAY = new ParameterConfig<>(
        "senders.failover-delay",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        NonNegativeValidator.instance());
    ParameterConfig<Integer> SYNC_SERVER_THREADS = new ParameterConfig<>(
        DEFAULT_SERVER_SECTION + ".syncserver_threads",
        Integer::valueOf,
        PositiveValidator.instance());
    ParameterConfig<Integer> SYNC_SERVER_QUEUE_SIZE = new ParameterConfig<>(
        DEFAULT_SERVER_SECTION + ".syncserver_queue_size",
        Integer::valueOf,
        PositiveValidator.instance());
    ParameterConfig<Integer> MAX_EXPECTED_SEARCH_BACKENDS =
        new ParameterConfig<>(
            "max-expected-search-backends",
            Integer::valueOf,
            PositiveValidator.instance());
    ParameterConfig<String> KEYBOARD_OAUTH_SCOPE = new ParameterConfig<>(
        "oauth-scope",
        String::trim,
        NonEmptyValidator.INSTANCE);
    NullableSectionConfig<
        DkimStatsConfig,
        ImmutableDkimStatsConfig,
        DkimStatsConfigBuilder>
        DKIM_STATS_CONFIG = new NullableSectionConfig<>(
            "dkim-stats",
            DkimStatsConfigBuilder::new,
            ImmutableDkimStatsConfig::new,
            null,
            DkimStatsConfigDefaults.INSTANCE,
            null);

    LoggerConfig errorLogConfig();

    FactorsLogConfig tskvLogConfig();

    FilterSearchConfig threadsConfig();

    URIConfig labelsConfig();

    FilterSearchConfig corpFilterSearchConfig();

    URIConfig corpLabelsConfig();

    URIConfig corpFoldersConfig();

    HttpHostConfig blackboxConfig();

    Tvm2ClientConfig blackboxTvm2ClientConfig();

    HttpHostConfig corpBlackboxConfig();

    Tvm2ClientConfig corpBlackboxTvm2ClientConfig();

    Tvm2ClientConfig corpFilterSearchTvm2ClientConfig();

    HttpHostConfig userSplitConfig();

    HttpHostConfig corpMlConfig();

    HttpHostConfig iexProxyConfig();

    HttpTargetConfig proxyConfig();

    FiltersConfig filtersConfig();

    EnlargeConfig enlargeConfig();

    StaterConfig backendsResponsesStaterConfig();

    StaterConfig filterSearchResponsesStaterConfig();

    StaterConfig searchBackendsResolveResponsesStaterConfig();

    StaterConfig searchFilterMailSearchStaterConfig();

    SoCheckConfig soCheckConfig();

    ErratumConfig erratumConfig();

    SuggestConfig suggestConfig();

    RankingConfig rankingConfig();

    SubscriptionsConfig subscriptionsConfig();

    ClassificationConfig classificationConfig();

    ChemodanConfig chemodanConfig();

    MultisearchConfig multisearchConfig();

    Pattern forbiddenRequests();

    boolean pureSearch();

    boolean indexSearchRequests();

    boolean queryLanguage();

    boolean topRelevant();

    String pgQueue();

    String pgCorpQueue();

    String oracleQueue();

    String oracleCorpQueue();

    long failoverSearchDelay();

    long sendersFailoverDelay();

    int syncServerThreads();

    int syncServerQueueSize();

    int maxExpectedSearchBackends();

    HttpTargetConfig keyboardBackendConfig();

    String keyboardOAuthScope();

    DkimStatsConfig dkimStatsConfig();

    AddressPgConfig pgPoolConfig();
}

