package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class MsearchProxyConfigBuilder
    extends AbstractMsearchProxyConfigBuilder<MsearchProxyConfigBuilder>
{
    public MsearchProxyConfigBuilder() {
        this(MsearchProxyConfigDefaults.INSTANCE);
    }

    public MsearchProxyConfigBuilder(final MsearchProxyConfig config) {
        super(config);
    }

    public MsearchProxyConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, MsearchProxyConfigDefaults.INSTANCE);
    }

    public MsearchProxyConfigBuilder(
        final IniConfig config,
        final MsearchProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public MsearchProxyConfigBuilder self() {
        return this;
    }

    public ImmutableMsearchProxyConfig build() throws ConfigException {
        return new ImmutableMsearchProxyConfig(this);
    }
}

