package ru.yandex.msearch.proxy.config;

import java.util.regex.Pattern;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.erratum.ErratumConfigDefaults;
import ru.yandex.http.config.FilterSearchConfig;
import ru.yandex.http.config.FilterSearchConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigDefaults;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.logger.MinimalLoggerConfigDefaults;
import ru.yandex.msearch.proxy.api.async.mail.classification.ClassificationConfig;
import ru.yandex.msearch.proxy.api.async.mail.classification.ClassificationConfigDefaults;
import ru.yandex.passport.search.config.MultisearchConfig;
import ru.yandex.search.msal.pool.AddressPgConfig;
import ru.yandex.search.msal.pool.AddressPgConfigDefaults;
import ru.yandex.search.msal.pool.PoolConfig;
import ru.yandex.search.msal.pool.PoolConfigDefaults;
import ru.yandex.stater.StaterConfig;
import ru.yandex.stater.StaterConfigBuilder;
import ru.yandex.stater.StaterConfigDefaults;

public class MsearchProxyConfigDefaults
    extends AsyncHttpServerBaseConfigDefaults
    implements MsearchProxyConfig
{
    public static final MsearchProxyConfigDefaults INSTANCE =
        new MsearchProxyConfigDefaults();

    private static final long DEFAULT_FAILOVER_SEARCH_DELAY = 1000L;
    private static final long DEFAULT_SENDERS_FAILOVER_DELAY = 100L;
    private static final int DEFAULT_SYNC_SERVER_THREADS = 100;
    private static final int DEFAULT_SYNC_SERVER_QUEUE_SIZE = 1000;
    private static final int DEFAULT_MAX_EXPECTED_SEARCH_BACKENDS = 8;

    protected MsearchProxyConfigDefaults() {
    }

    @Override
    public MinimalLoggerConfigDefaults errorLogConfig() {
        return MinimalLoggerConfigDefaults.INSTANCE;
    }

    @Override
    public FactorsLogConfigDefaults tskvLogConfig() {
        return FactorsLogConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfigDefaults labelsConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public FilterSearchConfigDefaults corpFilterSearchConfig() {
        return FilterSearchConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfigDefaults corpLabelsConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfigDefaults corpFoldersConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults blackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ClientConfig blackboxTvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults corpBlackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ClientConfig corpBlackboxTvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ClientConfig corpFilterSearchTvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public FiltersConfigDefaults filtersConfig() {
        return FiltersConfigDefaults.INSTANCE;
    }

    @Override
    public EnlargeConfigDefaults enlargeConfig() {
        return EnlargeConfigDefaults.INSTANCE;
    }

    @Override
    public BackendsStaterConfigDefaults backendsResponsesStaterConfig() {
        return BackendsStaterConfigDefaults.INSTANCE;
    }

    @Override
    public FilterSearchStaterConfigDefaults
    filterSearchResponsesStaterConfig()
    {
        return FilterSearchStaterConfigDefaults.INSTANCE;
    }

    @Override
    public BackendsResolveStaterConfigDefaults
    searchBackendsResolveResponsesStaterConfig()
    {
        return BackendsResolveStaterConfigDefaults.INSTANCE;
    }

    @Override
    public SoCheckConfigDefaults soCheckConfig() {
        return SoCheckConfigDefaults.INSTANCE;
    }

    @Override
    public ErratumConfigDefaults erratumConfig() {
        return ErratumConfigDefaults.INSTANCE;
    }

    @Override
    public SuggestConfigDefaults suggestConfig() {
        return SuggestConfigDefaults.INSTANCE;
    }

    @Override
    public RankingConfig rankingConfig() {
        return RankingConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults userSplitConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults iexProxyConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public Pattern forbiddenRequests() {
        return null;
    }

    @Override
    public boolean pureSearch() {
        return false;
    }

    @Override
    public boolean indexSearchRequests() {
        return false;
    }

    @Override
    public boolean queryLanguage() {
        return false;
    }

    @Override
    public boolean topRelevant() {
        return false;
    }

    @Override
    public String pgQueue() {
        return "change_log";
    }

    @Override
    public String pgCorpQueue() {
        return "corp_change_log";
    }

    @Override
    public String oracleQueue() {
        return "opqueue";
    }

    @Override
    public String oracleCorpQueue() {
        return "opqueue_corp";
    }

    @Override
    public long failoverSearchDelay() {
        return DEFAULT_FAILOVER_SEARCH_DELAY;
    }

    @Override
    public long sendersFailoverDelay() {
        return DEFAULT_SENDERS_FAILOVER_DELAY;
    }

    @Override
    public int syncServerThreads() {
        return DEFAULT_SYNC_SERVER_THREADS;
    }

    @Override
    public int syncServerQueueSize() {
        return DEFAULT_SYNC_SERVER_QUEUE_SIZE;
    }

    @Override
    public int maxExpectedSearchBackends() {
        return DEFAULT_MAX_EXPECTED_SEARCH_BACKENDS;
    }

    @Override
    public HttpTargetConfig proxyConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public HttpTargetConfig keyboardBackendConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public String keyboardOAuthScope() {
        return "mail:search";
    }

    public FilterSearchConfig threadsConfig() {
        return ThreadInfoConfigDefaults.INSTANCE;
    }

    @Override
    public SubscriptionsConfig subscriptionsConfig() {
        return SubscriptionsConfigDefaults.INSTANCE;
    }

    @Override
    public ClassificationConfig classificationConfig() {
        return ClassificationConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig corpMlConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public StaterConfig searchFilterMailSearchStaterConfig() {
        return new StaterConfigBuilder(StaterConfigDefaults.INSTANCE)
            .prefix("search-filter");
    }

    @Override
    public ChemodanConfig chemodanConfig() {
        return ChemodanConfigDefaults.INSTANCE;
    }

    @Override
    public DkimStatsConfig dkimStatsConfig() {
        return DkimStatsConfigDefaults.INSTANCE;
    }

    @Override
    public AddressPgConfig pgPoolConfig() {
        return AddressPgConfigDefaults.INSTANCE;
    }

    @Override
    public MultisearchConfig multisearchConfig() {
        return null;
    }
}

