package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class RankingConfigBuilder
    extends AbstractRankingConfigBuilder<RankingConfigBuilder>
{
    public RankingConfigBuilder() {
        super(RankingConfigDefaults.INSTANCE);
    }

    public RankingConfigBuilder(final RankingConfig config) {
        super(config);
    }

    public RankingConfigBuilder(final IniConfig config) throws ConfigException {
        this(config, RankingConfigDefaults.INSTANCE);
    }

    public RankingConfigBuilder(
        final IniConfig config,
        final RankingConfig defaults) throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public RankingConfigBuilder self() {
        return this;
    }

    public ImmutableRankingConfig build() throws ConfigException {
        return new ImmutableRankingConfig(this);
    }
}
