package ru.yandex.msearch.proxy.config;

import java.util.Set;

import ru.yandex.matrixnet.MatrixnetModelConfig;
import ru.yandex.msearch.proxy.api.async.mail.Product;
import ru.yandex.msearch.proxy.api.async.mail.Side;

public interface RelevanceConfig extends MatrixnetModelConfig {
    enum RelevanceUsageStatus {
        EXPERIMENT,
        DEFAULT,
        DISABLED
    }

    String testId();

    Set<String> factors();

    /**
     * List of products for experiment (pdd/bp/corp etc)
     * @return
     */
    Set<Product> products();

    /**
     * List of products for experiment (web/touchsm/mobile etc)
     * @return
     */
    Set<Side> sides();

    RelevanceUsageStatus usageStatus();
}
