package ru.yandex.msearch.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class SoCheckConfigBuilder
    extends AbstractSoCheckConfigBuilder<SoCheckConfigBuilder>
{
    public SoCheckConfigBuilder() {
        super(SoCheckConfigDefaults.INSTANCE);
    }

    public SoCheckConfigBuilder(final SoCheckConfig config) {
        super(config);
    }

    public SoCheckConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, SoCheckConfigDefaults.INSTANCE);
    }

    public SoCheckConfigBuilder(
        final IniConfig config,
        final SoCheckConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public SoCheckConfigBuilder self() {
        return this;
    }

    public ImmutableSoCheckConfig build() throws ConfigException {
        return new ImmutableSoCheckConfig(this);
    }
}

