package ru.yandex.msearch.proxy.config;

import ru.yandex.http.config.URIConfigDefaults;

public class SoCheckConfigDefaults
    extends URIConfigDefaults
    implements SoCheckConfig
{
    public static final SoCheckConfigDefaults INSTANCE =
        new SoCheckConfigDefaults();

    private static final long DEFAULT_FAKE_REQUEST_INTERVAL = 300L;
    private static final int DEFAULT_CONNECTIONS = 20;
    private static final int DEFAULT_TIMEOUT = 100;

    protected SoCheckConfigDefaults() {
    }

    @Override
    public boolean banSpam() {
        return false;
    }

    @Override
    public String fakeRequest() {
        return null;
    }

    @Override
    public long fakeRequestInterval() {
        return DEFAULT_FAKE_REQUEST_INTERVAL;
    }

    // Override some HttpTargetConfig defaults
    @Override
    public int connections() {
        return DEFAULT_CONNECTIONS;
    }

    @Override
    public int timeout() {
        return DEFAULT_TIMEOUT;
    }
}

