package ru.yandex.msearch.proxy.config;

public interface SubjectSuggestConfig {

    /**
     * Maximum number of suggests, to return.
     * Could be overrided by query param
     * @return suggests limit
     */
    int limit();

    /**
     * Status of suggest service
     * @return true if enabled
     */
    boolean enabled();

    /**
     * Should we response on empty request or fail
     * @return true if response OK
     */
    boolean responseOnEmpty();

    /**
     * Minimum word length to present in search
     * @return minimum word length
     */
    int subjectMinimumWordLength();

    /**
     * Minimum length of  normalized request to
     * apply morphological search
     *
     * @return minimum request len
     */
    int minimumRequestLenToMorpho();

    /**
     * Minimum length of request to store it
     *
     * @return min length
     */
    int minimumRequestStoreLen();
}
