package ru.yandex.msearch.proxy.config;

/**
 * Default config values for suggest route
 *
 */
public class SubjectSuggestConfigDefaults implements SubjectSuggestConfig {
    public static final SubjectSuggestConfigDefaults INSTANCE = new SubjectSuggestConfigDefaults();

    private static final boolean ENABLED  = false;
    private static final int LIMIT = 10;
    private static final int SUBJECT_MINIMUM_WORD_LENGTH = 0;
    private static final int SUBJECT_MINIMUM_MORPHO_REQUEST_LENGTH = 6;
    private static final boolean RESPONSE_ON_EMPTY_REQUEST = true;
    private static final int DEFAULT_MIN_REQUEST_LEN_TO_STORE = 3;

    @Override
    public int limit() {
        return LIMIT;
    }

    @Override
    public boolean enabled() {
        return ENABLED;
    }

    @Override
    public boolean responseOnEmpty() {
        return RESPONSE_ON_EMPTY_REQUEST;
    }

    @Override
    public int subjectMinimumWordLength() {
        return SUBJECT_MINIMUM_WORD_LENGTH;
    }

    @Override
    public int minimumRequestLenToMorpho() {
        return SUBJECT_MINIMUM_MORPHO_REQUEST_LENGTH;
    }

    @Override
    public int minimumRequestStoreLen() {
        return DEFAULT_MIN_REQUEST_LEN_TO_STORE;
    }
}
