package ru.yandex.msearch.proxy.config;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import ru.yandex.http.config.HttpTargetConfigDefaults;
import ru.yandex.parser.email.types.MessageType;

public class SubscriptionsConfigDefaults
    extends HttpTargetConfigDefaults
    implements SubscriptionsConfig
{
    public static final SubscriptionsConfigDefaults INSTANCE =
        new SubscriptionsConfigDefaults();

    private static final int DEFAULT_LAST_DAYS = 365;
    private static final int DEFAULT_TIMEOUT = 15000;
    private static final int DEFAULT_FAILOVER_DELAY = 100;

    private static final int DEFAULT_MINIMUM_TOTAL = 0;
    private static final List<MessageType> DEFAULT_TYPES =
        Arrays.asList(MessageType.NEWS, MessageType.NOTIFICATION);

    @Override
    public int minMailsInSubcscriptions() {
        return DEFAULT_MINIMUM_TOTAL;
    }

    @Override
    public List<MessageType> messageTypes() {
        return DEFAULT_TYPES;
    }

    @Override
    public int minimalMailAge() {
        return DEFAULT_LAST_DAYS;
    }

    @Override
    public int timeout() {
        return DEFAULT_TIMEOUT;
    }

    @Override
    public int connectTimeout() {
        return DEFAULT_TIMEOUT;
    }

    @Override
    public int poolTimeout() {
        return DEFAULT_TIMEOUT;
    }

    @Override
    public int connections() {
        return 2;
    }

    @Override
    public File pinnedDisplayNames() {
        return null;
    }

    @Override
    public long failoverDelay() {
        return DEFAULT_FAILOVER_DELAY;
    }
}
