package ru.yandex.msearch.proxy.config;

import java.util.Map;

import ru.yandex.http.config.DnsConfig;
import ru.yandex.http.config.HttpTargetConfig;

import ru.yandex.msearch.proxy.MsearchProxyExperiment;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;
import ru.yandex.msearch.proxy.api.async.suggest.united.TargetWeight;

public interface SuggestConfig {
    DnsConfig dnsConfig();

    SubjectSuggestConfig subjectConfig();

    ContactSuggestConfig contactConfig();

    //show mails as suggest
    MailSuggestConfig mailConfig();

    HttpTargetConfig searchClientConfig();

    int searchClientResolution();

    /**
     * Enables senders/receivers targets. When we have only 1 contact suggest,
     * we add extra suggests with from/to separate suggests
     *
     * @return
     */
    boolean sendersReceivers();

    /**
     * If enabled, allows to convert history suggest to contact suggest,
     * if it matches pattern from:xx or to:xx
     * @return
     */
    boolean historyToContacts();

    /**
     * If we have more than one contact suggests from one domain,
     * we adding extra suggest just for domain.
     * @return
     */
    boolean contactDomainSuggest();

    int limit();

    boolean twoStepsRequest();

    long timeout();

    boolean highlight();

    /**
     * If false, will fail full request on original request fail
     * @return True if OK status on original request is mandatory
     */
    boolean translitOriginalMandatory();

    Map<Target, TargetWeight> weights();

    Map<MsearchProxyExperiment, Map<Target, TargetWeight>> expsWeights();
}
