package ru.yandex.msearch.proxy.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.http.config.DnsConfig;
import ru.yandex.http.config.DnsConfigBuilder;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.msearch.proxy.MsearchProxyExperiment;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;
import ru.yandex.msearch.proxy.api.async.suggest.united.TargetWeight;

public class SuggestConfigDefaults implements SuggestConfig {
    public static final SuggestConfigDefaults INSTANCE
        = new SuggestConfigDefaults();

    private static final int TIMEOUT = 200;
    private static final int DEFAULT_RESOLUTION = 20;
    private static final int DEFAULT_DNS_TTL = 3600000;
    private static final int DEFAULT_DNS_UPD_INTERVAL = 600000;

    private static final DnsConfig DEFAULT_DNS_CONFIG =
        new DnsConfigBuilder()
            .dnsUpdateInterval(DEFAULT_DNS_UPD_INTERVAL)
            .dnsTtl(DEFAULT_DNS_TTL);
    private static final HttpTargetConfig DEFAULT_SEARCH_CONFIG =
        new HttpTargetConfigBuilder()
            .connectTimeout(TIMEOUT)
            .poolTimeout(TIMEOUT)
            .sessionTimeout(TIMEOUT);

    private static final int LIMIT = 10;

    public static final Map<Target, TargetWeight> DEFAULT_WEIGHTS;

    static {
        Map<Target, TargetWeight> usual = new HashMap<>();
        usual.put(Target.HISTORY, new TargetWeight(2, 6));
        usual.put(Target.CONTACT, new TargetWeight(2, 5, 6));
        usual.put(Target.SENDER, new TargetWeight(2, 4));
        usual.put(Target.RECEIVER, new TargetWeight(2, 3));
        usual.put(Target.SUBJECT, new TargetWeight(2, 2));
        usual.put(Target.MAIL, new TargetWeight(2, 1));
        usual.put(Target.FOLDER, new TargetWeight(1, 6));
        usual.put(Target.UNREAD, new TargetWeight(1, 5));
        usual.put(Target.IMPORTANT, new TargetWeight(1, 4));
        usual.put(Target.LABEL, new TargetWeight(1, 3));
        usual.put(Target.CATEGORY, new TargetWeight(1, 2));
        usual.put(Target.QL, new TargetWeight(1, 1));

        DEFAULT_WEIGHTS = Collections.unmodifiableMap(usual);
    }

    @Override
    public DnsConfig dnsConfig() {
        return DEFAULT_DNS_CONFIG;
    }

    @Override
    public SubjectSuggestConfig subjectConfig() {
        return SubjectSuggestConfigDefaults.INSTANCE;
    }

    @Override
    public ContactSuggestConfig contactConfig() {
        return ContactSuggestConfigDefaults.INSTANCE;
    }

    @Override
    public int limit() {
        return LIMIT;
    }

    @Override
    public boolean twoStepsRequest() {
        return false;
    }

    @Override
    public long timeout() {
        return TIMEOUT;
    }

    @Override
    public boolean highlight() {
        return false;
    }

    @Override
    public boolean sendersReceivers() {
        return false;
    }

    @Override
    public boolean historyToContacts() {
        return false;
    }

    @Override
    public boolean contactDomainSuggest() {
        return false;
    }

    @Override
    public HttpTargetConfig searchClientConfig() {
        return DEFAULT_SEARCH_CONFIG;
    }

    @Override
    public int searchClientResolution() {
        return DEFAULT_RESOLUTION;
    }

    @Override
    public boolean translitOriginalMandatory() {
        return true;
    }

    @Override
    public MailSuggestConfig mailConfig() {
        return MailSuggestConfigDefaults.INSTANCE;
    }

    @Override
    public Map<Target, TargetWeight> weights() {
        return DEFAULT_WEIGHTS;
    }

    @Override
    public Map<MsearchProxyExperiment, Map<Target, TargetWeight>> expsWeights() {
        return Collections.emptyMap();
    }
}
