package ru.yandex.msearch.proxy.config;

import java.net.URI;
import java.net.URISyntaxException;

import ru.yandex.http.config.FilterSearchConfigDefaults;

public class ThreadInfoConfigDefaults extends FilterSearchConfigDefaults {
    public static final ThreadInfoConfigDefaults INSTANCE =
        new ThreadInfoConfigDefaults();

    private static final URI DEFAULT_URI;

    static {
        try {
            DEFAULT_URI =
                new URI("http://api.mail.yandex.net/api/threads_info")
                    .parseServerAuthority();
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI uri() {
        return DEFAULT_URI;
    }
}
