package ru.yandex.msearch.proxy.dispatcher;

import java.net.URI;
import java.net.URISyntaxException;

import java.nio.charset.CharacterCodingException;

import org.apache.http.client.methods.HttpRequestBase;

import ru.yandex.function.StringBuilderProcessorAdapter;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.searchmap.SearchMap;

import ru.yandex.parser.uri.PctEncoder;
import ru.yandex.parser.uri.PctEncodingRule;

import ru.yandex.search.prefix.Prefix;

public abstract class AbstractDispatcher implements Dispatcher {
    protected final DispatcherFactory factory;
    protected final Prefix prefix;
    protected final String db;
    protected final SearchMap searchMap;
    protected final boolean precise;
    protected final HttpServer.RequestContext ctx;

    public AbstractDispatcher(
        final DispatcherFactory factory,
        final Prefix prefix,
        final String db,
        final SearchMap searchMap,
        final boolean precise,
        final HttpServer.RequestContext ctx)
    {
        this.factory = factory;
        this.prefix = prefix;
        this.db = db;
        this.searchMap = searchMap;
        this.precise = precise;
        this.ctx = ctx;
    }

    public String hostName(final SearchMap.Host host) {
        return host.url.replace(":" + host.params.get("search_port"), "");
    }

    public int newSearchPort(final SearchMap.Host host) {
        final String newSearchPortStr = host.params.get("search_port_ng");
        if (newSearchPortStr == null) {
            return DispatcherFactory.LUCENE_SEARCH_PORT;
        }
        return Integer.parseInt(newSearchPortStr);
    }

    public int indexPort(final SearchMap.Host host) {
        final String indexerPortStr = host.params.get("json_indexer_port");
        if (indexerPortStr == null) {
            return DispatcherFactory.LUCENE_JSON_PORT;
        }
        return Integer.parseInt(indexerPortStr);
    }

    public StringBuilder addSessionId(final URI uri) {
	StringBuilder sb = new StringBuilder(uri.toASCIIString());
	if (uri.getRawQuery() == null) {
	    sb.append('?');
	} else {
	    sb.append('&');
	}
        sb.append("proxy_session_id=");
        sb.append(ctx.getSessionId());
        return sb;
    }

    public HttpRequestBase addSessionId(final HttpRequestBase request)
        throws DispatcherException
    {
        String uri = new String(addSessionId(request.getURI()));
        try {
            request.setURI(new URI(uri));
        } catch (URISyntaxException e) {
            throw new DispatcherException(e);
        }
        return request;
    }

    public HttpRequestBase addUserInfo(final HttpRequestBase request)
        throws DispatcherException
    {
        StringBuilder sb = addSessionId(request.getURI());
        sb.append("&service=");
        sb.append(db);
        sb.append("&shard=");
        sb.append(prefix.hash() % 65534);
        sb.append("&prefix=");
        PctEncoder encoder = new PctEncoder(PctEncodingRule.QUERY);
        try {
            encoder.process(prefix.toString().toCharArray());
            encoder.processWith(new StringBuilderProcessorAdapter(sb));
            request.setURI(new URI(new String(sb)));
        } catch (CharacterCodingException | URISyntaxException e) {
            throw new DispatcherException(e);
        }
        return request;
    }
}

