package ru.yandex.msearch.proxy.dispatcher;

import ru.yandex.msearch.proxy.MsearchProxyException;

public class DispatcherException extends MsearchProxyException
{
public static final long serialVersionUID = 0;

    public DispatcherException()
    {
        super();
    }

    public DispatcherException( Throwable t )
    {
        super(t);
    }

    public DispatcherException( String message )
    {
        super( message );
    }

    public DispatcherException( String message, Throwable t )
    {
        super( message, t );
    }

    public static class BadRequestException extends DispatcherException
    {
        public BadRequestException( String message )
        {
            super( message );
        }

        public BadRequestException( String message, Throwable t )
        {
            super( message, t );
        }
    }

    public static class NotFoundException extends BadRequestException
    {
        public NotFoundException( String message )
        {
            super( message );
        }

        public NotFoundException( String message, Throwable t )
        {
            super( message, t );
        }
    }

    public static class BadResponseException extends DispatcherException
    {
    private int code;
    private String address;
    private String response;

        public BadResponseException( int code, String address, String response )
        {
            super();
            this.code = code;
            this.address = address;
            this.response = response;
        }


        @Override
        public String getMessage()
        {
            return "Backend<" + address + ">: response code = " + code + ", response body: " + response;
        }

        public int code()
        {
            return code;
        }

        public String response()
        {
            return response;
        }

        public String address()
        {
            return address;
        }
    }

    public static class IOException extends DispatcherException
    {
    private String address;

        public IOException( String address, java.io.IOException e )
        {
            super( "Backend<" + address + ": IOException: " + e.getMessage(), e );
            this.address = address;
        }

        public String address()
        {
            return address;
        }
    }

    public static class UnhandledError extends DispatcherException
    {
    private String address;

        public UnhandledError( String address, Throwable t )
        {
            super( "Backend<" + address + ": Unhandled exception: " + t.getMessage(), t );
            this.address = address;
        }

        public String address()
        {
            return address;
        }
    }

    public static class BadGateway extends DispatcherException
    {
    private String address;

        public BadGateway( String address )
        {
            super();
            this.address = address;
        }

        public String address()
        {
            return address;
        }
    }
}
