package ru.yandex.msearch.proxy.dispatcher;

import java.util.LinkedList;
import java.util.List;

import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.logger.Logger;

public class SequentialHttpRequestDispatcherAndReader implements DispatcherAndReader
{
private final HttpServer.RequestContext ctx;

    public SequentialHttpRequestDispatcherAndReader( HttpServer.RequestContext ctx )
    {
	this.ctx = ctx;
    }

    @Override
    public String dispatch( List<DispatcherHttpHost> hosts, HttpRequestBase request, int timeout ) throws DispatcherException
    {
	LinkedList<Exception> exceptions = null;
	for( DispatcherHttpHost host : hosts )
	{
	    ctx.log.debug( "SequentialHttpRequestDispatcherAndReader.dispatch: trying host: " + host );
	    CloseableHttpResponse response = null;
	    try
	    {
		response = host.execute( request, timeout, ctx );
        	int httpCode = response.getStatusLine().getStatusCode();
	        if( httpCode < 200 || httpCode >= 500 )
	        {
	    	    String body = "";
	            if( response.getEntity() != null )
	            {
	        	body = EntityUtils.toString( response.getEntity() );
	            }
	            ctx.log.err( "SequentialHttpRequestDispatcherAndReader.dispatch: error: server returned status: " + httpCode + ", response body: " + body );
	            if( exceptions == null ) exceptions = new LinkedList<Exception>();
	            exceptions.add( new DispatcherException.BadResponseException( httpCode, host.addressString(), body ) );
		}
		else
		{
	    	    String body = "";
	            if( response.getEntity() == null )
	            {
	                body = "empty response";
	                ctx.log.err( "SequentialHttpRequestDispatcherAndReader.dispatch: error: server returned status: " + httpCode + ", response body: " + body );
	                if( exceptions == null ) exceptions = new LinkedList<Exception>();
	                exceptions.add( new DispatcherException.BadResponseException( httpCode, host.addressString(), body ) );
	            }
		    return EntityUtils.toString( response.getEntity() );
		}
	    }
	    catch( Exception e )
	    {
	        ctx.log.err( "SequentialHttpRequestDispatcherAndReader.dispatch: error querying host <" + host.addressString() + "> : " + Logger.exception(e) );
	        if( exceptions == null ) exceptions = new LinkedList<Exception>();
	        exceptions.add( new DispatcherException.UnhandledError( host.addressString(), e ) );
	    }
	}
	DispatcherException e = new DispatcherException( "Can't find backend for searching" );
	if( exceptions != null )
	{
	    for( Exception s : exceptions )
	    {
		e.addSuppressed( s );
	    }
	}
	throw e;
    }
}
