package ru.yandex.msearch.proxy.dispatcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.apache.commons.io.IOUtils;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.httpclient.CommonHttpClient;
import ru.yandex.msearch.proxy.searchmap.SearchMap;

import ru.yandex.search.prefix.Prefix;

public class SynchronousDispatcher extends AbstractDispatcher
{
    public SynchronousDispatcher( DispatcherFactory factory, Prefix prefix, String db, SearchMap searchMap, boolean precise, HttpServer.RequestContext ctx )
    {
        super(factory, prefix, db, searchMap, precise, ctx);
    }

    @Override
    public List<DispatcherHttpHost> getSearchHosts() throws DispatcherException
    {
	LinkedList<SearchMap.Host> shosts = searchMap.getHosts( db, prefix );
	if( shosts == null )
	{
	    throw new DispatcherException.BadRequestException( "error: user <" + prefix + "> cannot be bound to any server." );
	}
	ArrayList<DispatcherHttpHost> hosts = new ArrayList<DispatcherHttpHost>(shosts.size());
	for( SearchMap.Host host : shosts )
	{
	    hosts.add( factory.createLuceneHost(ctx, host.url.replace( ":" + host.params.get("search_port"), "" ), newSearchPort(host), db) );
	}
        factory.sortHostsByAVGTime(hosts);
	return hosts;
    }

    public List<DispatcherHttpHost> getIndexHosts() throws DispatcherException
    {
    LinkedList<SearchMap.Host> shosts = searchMap.getHosts( db, prefix );
    if( shosts == null )
    {
        throw new DispatcherException.BadRequestException( "error: user <" + prefix + "> cannot be bound to any server." );
    }
    ArrayList<DispatcherHttpHost> hosts = new ArrayList<DispatcherHttpHost>(shosts.size());
    for( SearchMap.Host host : shosts )
    {
        hosts.add( factory.createLuceneHost(ctx, host.url.replace( ":" + host.params.get("search_port"), "" ), indexPort(host), db) );
    }
    return hosts;
    }

    @Override
    public CloseableHttpResponse searchDispatch( HttpRequestBase request, int timeout ) throws DispatcherException
    {
        long start = System.currentTimeMillis();
	List<DispatcherHttpHost> hosts = getSearchHosts();

        SequentialHttpRequestDispatcher httpDispatcher = new SequentialHttpRequestDispatcher( ctx );
	return httpDispatcher.dispatch( hosts, addSessionId(request), timeout - (int)(System.currentTimeMillis() - start) );
    }

    @Override
    public void indexDispatch( HttpRequestBase request, int timeout ) throws DispatcherException
    {
        long start = System.currentTimeMillis();
        List<DispatcherHttpHost> hosts = getIndexHosts();

        request = addUserInfo(request);
        for (DispatcherHttpHost host: hosts) {
            String address = host.addressString();
            long dispatchStart = System.currentTimeMillis();
            ctx.log.info( "SynchronousDispatcher.dispatch: dispatching to: " + host );
            try (CloseableHttpResponse response = host.execute(CommonHttpClient.httpClient, request, timeout - (int)(System.currentTimeMillis() - start), ctx)) {
                try (InputStream is = response.getEntity().getContent()) {
                    int responseCode = response.getStatusLine().getStatusCode();
                    if (responseCode == 0) {
                        throw new DispatcherException.BadGateway(address);
                    } else if (responseCode < 200 || responseCode >= 400) {
                        StringWriter sw = new StringWriter();
                        IOUtils.copy(is, sw, "UTF-8");
                        String responseBody = sw.toString();
                        throw new DispatcherException.BadResponseException( responseCode, address, responseBody );
                    }
                }
            } catch (DispatcherException rethrow) {
                throw rethrow;
            } catch (IOException e) {
                throw new DispatcherException.UnhandledError(address, e);
            } finally {
                ctx.log.info( "SynchronousDispatcher.dispatch: " +
                    "dispatching time to: " + host + ": " + 
                    (System.currentTimeMillis() - dispatchStart));
            }
        }
    }
}
