package ru.yandex.msearch.proxy.document;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.search.result.FilterSearchDocument;
import ru.yandex.search.result.SearchDocument;

public class MailSearchDocument extends FilterSearchDocument {
    private final String mid;

    public MailSearchDocument(final SearchDocument document, final String mid) {
        super(document);

        this.mid = mid;
    }

    public MailSearchDocument(final SearchDocument document) {
        super(document);

        this.mid = document.attrs().get(MailIndexFields.MID);
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof MailSearchDocument) {
            MailSearchDocument other = (MailSearchDocument) o;

            return mid.equals(other.mid);
        }

        return false;
    }

    @Override
    public int hashCode() {
        return mid.hashCode();
    }
}
