package ru.yandex.msearch.proxy.experiment;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class UserSplit {
    private final String configVersion;
    private final Set<String> tests;

    public UserSplit(
        final String config,
        final String tests,
        final String flags)
        throws MalformedUserSplitException
    {
        this.tests = new LinkedHashSet<>();
        this.configVersion = config;

        for (String test: tests.split(";")) {
            String text = test.trim();

            if (!text.isEmpty()) {
                String pTest = parseTest(text);
                if (pTest != null) {
                    this.tests.add(parseTest(text));
                }
            }
        }
    }

    public Set<String> tests() {
        return tests;
    }

    protected String parseTest(final String test)
        throws MalformedUserSplitException
    {
        String[] split = test.split(",");
        if (split.length == 0) {
            return null;
        }

        if (split.length != 3) {
            throw new MalformedUserSplitException(
                "Malformed test triple " + test);
        }

        return split[0];
    }

    public String testsToString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String test: tests) {
            if (i != 0) {
                builder.append(',');
            }

            builder.append(test);
            i++;
        }

        return builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigVersion:");
        sb.append(configVersion);
        sb.append("Experiments:");
        sb.append(testsToString());
        return sb.toString();
    }
}
