package ru.yandex.msearch.proxy.experiment;

import java.io.IOException;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import ru.yandex.http.util.nio.DevNullAsyncConsumer;

public class UserSplitAsyncResponseConsumer extends
    DevNullAsyncConsumer<UserSplit>
{
    private static final String CONFIG_HEADER = "X-Yandex-ExpConfigVersion";
    private static final String FLAGS_HEADER = "X-Yandex-ExpFlags";
    private static final String TESTS_HEADER = "X-Yandex-ExpBoxes";

    private final HttpResponse response;

    public UserSplitAsyncResponseConsumer(final HttpResponse response)
        throws HttpException, IOException
    {
        this.response = response;
    }

    @Override
    protected UserSplit buildResult(
        final HttpContext context) throws Exception
    {
        Header configHeader =
            response.getFirstHeader(CONFIG_HEADER);

        Header testsHeader = response.getFirstHeader(TESTS_HEADER);
        Header flagsHeader = response.getFirstHeader(FLAGS_HEADER);

        if (configHeader == null) {
            throw new MalformedUserSplitException(
                "Missing header " + CONFIG_HEADER);
        }

        String tests = null;
        if (testsHeader != null) {
            tests = testsHeader.getValue();
        }

        if (tests == null) {
            tests = "";
        }

        String flags = null;
        if (flagsHeader != null) {
            flags = flagsHeader.getValue();
        }

        if (flags == null) {
            flags = "";
        }

        return new UserSplit(
            configHeader.getValue(),
            tests,
            flags);
    }
}