package ru.yandex.msearch.proxy.highlight;

public class AdjustingWordsKeepingRequestMatchesConsumer
    extends IntervalRequestMatchesConsumer
{
    private final int maxWords;
    private final int minSymbols;
    private final String text;

    public AdjustingWordsKeepingRequestMatchesConsumer(
        final String text,
        final int maxWords,
        final int minSymbols)
    {
        super(true);

        this.maxWords = maxWords;
        this.minSymbols = minSymbols;
        this.text = text;
    }

    protected boolean isSpace(final char c) {
        return Character.isISOControl(c)
            || Character.isSpaceChar(c)
            || Character.isWhitespace(c);
    }

    protected int seek(final int pos, final int steps, final int step) {
        //first skip until end of word
        int curPos = pos;
        int start;
        for (start = 0; start < steps; start += 1) {
            if (isSpace(text.charAt(curPos))) {
                break;
            }

            curPos += step;
        }

        boolean betweenWords = true;
        int wordsCnt = 0;

        for (int i = start; i < steps; i += 1) {
            char c = text.charAt(curPos);
            if (isSpace(c)) {
                if (!betweenWords) {
                    betweenWords = true;
                    if (++wordsCnt >= maxWords && i >= minSymbols) {
                        return curPos - step;
                    }
                }
            } else {
                if (Character.isLetter(c)) {
                    betweenWords = false;
                }
            }

            curPos += step;
        }

        return curPos;
    }

    @Override
    public void apply(final int min, final int max) {
        int windowedMin = seek(Math.max(0, min - 1), min - 1, -1);
        int windowedMax = seek(Math.min(max, text.length() - 1), text.length() - max, 1);
        if (windowedMax < text.length() - 1) {
            windowedMax += 1;
        }

        super.apply(windowedMin, windowedMax);
    }
}
