package ru.yandex.msearch.proxy.highlight;

public class DoubleRequestMatchesConsumer implements RequestMatchesConsumer {
    private final RequestMatchesConsumer first;
    private final RequestMatchesConsumer second;

    public DoubleRequestMatchesConsumer(
        final RequestMatchesConsumer first,
        final RequestMatchesConsumer second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    public void apply(final int min, final int max) {
        first.apply(min, max);
        second.apply(min, max);
    }
}
