package ru.yandex.msearch.proxy.highlight;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.util.string.StringUtils;

public interface Highlighter {
    int MORPHO_THRSH = 6;
    int MORPHO_REDUCE= 2;
    // maximal length of word, to match it vs exact word in text
    // instead of matching with start of the word in text
    int WORD_MATCH_THRESHOLD= 2;

    JsonObject highlight(final String s, final int start, final int end);

    /**
     *
     * @param s - string to find in
     * @param preparedRequestWords - requests splitted into words
     * @param wordsStart - true if trying to match from start of the word
     * @param morpho - use morpho in search
     * @return
     */
    JsonObject highlight(
        final String s,
        final List<String> preparedRequestWords,
        boolean wordsStart,
        boolean morpho);

    default JsonObject highlight(
        final String s,
        final List<String> preparedRequestWords,
        boolean morpho)
    {
        return highlight(s, preparedRequestWords, true, true);
    }

    default JsonObject highlight(
        final String s,
        final String request,
        final boolean morpho)
    {
        return highlight(s, prepareRequest(request), false, morpho);
    }

    default String prepare(final String s) {
        StringBuilder sb = new StringBuilder(s.length());
        sb.append(' ');
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
            } else {
                sb.append(' ');
            }
        }

        return sb.toString().toLowerCase(Locale.ROOT);
    }

    default List<String> prepareRequest(final String request) {
        List<String> words = new ArrayList<>();
        boolean space = true;
        StringBuilder sb = null;
        for (int i = 0; i < request.length(); i++) {
            char c = request.charAt(i);
            if (Character.isISOControl(c)
                || Character.isSpaceChar(c)
                || Character.isWhitespace(c))
            {
                if (!space) {
                    words.add(sb.toString());
                    sb = null;
                }

                space = true;
                continue;
            } else if (space) {
                space = false;
                sb = new StringBuilder();
            }

            sb.append(Character.toLowerCase(c));
        }

        if (sb != null) {
            words.add(sb.toString());
        }

        return words;
    }

    default int indexOf(
        final String source,
        final int sourceOffset,
        final String target,
        final int targetOffset,
        final int targetCount)
    {
        if (targetCount == 0) {
            return 0;
        }

        char first = target.charAt(targetOffset);
        int max = (source.length() - targetCount);

        for (int i = sourceOffset; i <= max; i++) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                    ;
                }
            }

            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                for (int k = targetOffset + 1; j < end && source.charAt(j)
                    == target.charAt(k); j++, k++) {
                    ;
                }

                if (j == end) {
                    return i;
                }
            }
        }
        return -1;
    }
}
