package ru.yandex.msearch.proxy.highlight;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import ru.yandex.collection.IntInterval;

public class IntervalRequestMatchesConsumer
    extends ArrayList<IntInterval>
    implements RequestMatchesConsumer
{
    private final boolean merge;

    public IntervalRequestMatchesConsumer(final boolean merge) {
        super();
        this.merge = merge;
    }

    public IntervalRequestMatchesConsumer() {
        this(true);
    }

    protected void addWithMerge(
        final List<IntInterval> intervals,
        final IntInterval newInterval)
    {
        // we started search from beginning,
        // so interval could be appeared somewhere in middle
        IntInterval item = null;
        IntInterval interval = newInterval;

        ListIterator<IntInterval> intervalIt
            = intervals.listIterator();
        while (intervalIt.hasNext()) {
            item = intervals.get(intervalIt.nextIndex());
            if (item.min() >= interval.max()) {
                break;
            }

            intervalIt.next();
            if (interval.min() >= item.max()) {
                continue;
            }

            IntInterval merged = interval.mergeIfOverlaps(item);
            if (merged != null) {
                intervalIt.remove();
                interval = merged;
                break;
            }
        }

        while (intervalIt.hasNext()) {
            IntInterval next =
                intervals.get(intervalIt.nextIndex());
            if (next.min() > interval.max()) {
                intervalIt.add(interval);
                interval = null;
                break;
            }

            IntInterval merged = interval.mergeIfOverlaps(next);
            if (merged == null) {
                // very strange
                intervalIt.add(interval);
                interval = null;
                break;
            } else {
                intervalIt.next();
                intervalIt.remove();
                interval = merged;
            }
        }

        if (interval != null) {
            intervals.add(interval);
        }
    }

    @Override
    public void apply(final int min, final int max) {
        IntInterval interval = new IntInterval(min, max);
        apply(interval);
    }

    protected void apply(final IntInterval interval) {
        if (!merge) {
            add(interval);
        } else {
            if (size() <= 0 || get(size() - 1).max() < interval.min()) {
                add(interval);
                return;
            }

            addWithMerge(this, interval);
        }
    }
}
