package ru.yandex.msearch.proxy.httpclient;

import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.client.measurable.MeasurableHttpRequestExecutor;
import ru.yandex.http.util.client.measurable.MeasurablePoolingHttpClientConnectionManager;

import ru.yandex.msearch.proxy.logger.Logger;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class CommonHttpClient {

    public static PoolingHttpClientConnectionManager httpConnManager;
    public static HttpClientBuilder httpClientBuilder;
    public static CloseableHttpClient httpClient;

    public static final void init(final IniConfig config) throws ConfigException {
        int maxPerRoute = config.getInt("max_per_route", 250);
        int maxTotal = config.getInt("max_total", Integer.MAX_VALUE);

        int soTimeout = config.getInt("so_timeout", 30000);
        int soLinger = config.getInt("so_linger", 0);

        int connPoolTimeout = config.getInt("conn_pool_timeout", 1000);
        int connectTimeout = config.getInt("connect_timeout", 3000);

        final int connectionKeepAliveTime =
            config.getInt("connection_keep_alive_time", 5000);

        httpConnManager = new MeasurablePoolingHttpClientConnectionManager();
        httpConnManager.setDefaultMaxPerRoute( maxPerRoute );
        httpConnManager.setMaxTotal( maxTotal );
        httpConnManager.setValidateAfterInactivity(0);

        Logger.debug( "Initialized DispatcherFactory.PoolingHttpClientConnectionManager: \n" +
                "\tmaxPerRoute=" + maxPerRoute +
                "\n\tmaxTotal=" + maxTotal +
                "\n\tsoTimeout=" + soTimeout +
                "\n\tsoLinger=" + soLinger +
                "\n\tconnPoolTimeout=" + connPoolTimeout +
                "\n\tconnectTimeout=" + connectTimeout +
                "\n\tconnectionKeepAliveTime=" + connectionKeepAliveTime );

        SocketConfig defaultSocketConfig = SocketConfig.custom()
                .setTcpNoDelay(true)
                .setSoKeepAlive(true)
                .setSoReuseAddress(true)
                .setSoTimeout( soTimeout )
                .setSoLinger( soLinger )
                .build();

        RequestConfig defaultRequestConfig = RequestConfig.custom()
                .setConnectionRequestTimeout( connPoolTimeout )
                .setConnectTimeout( connectTimeout )
                .setStaleConnectionCheckEnabled( false )
                .setExpectContinueEnabled( false )
                .build();

        httpConnManager.setDefaultSocketConfig(defaultSocketConfig);

        httpClientBuilder = HttpClients.custom()
                .disableAuthCaching()
                .disableConnectionState()
                .disableCookieManagement()
                .disableRedirectHandling()
                .setConnectionManager( httpConnManager )
                .setRequestExecutor(new MeasurableHttpRequestExecutor());

        httpClient = httpClientBuilder
                .setDefaultRequestConfig( defaultRequestConfig )
                .setKeepAliveStrategy( new ConnectionKeepAliveStrategy()
                {
                    private final int keepAliveTime = connectionKeepAliveTime;
                    @Override
                    public long getKeepAliveDuration(final HttpResponse response, final HttpContext context)
                    {
                        return keepAliveTime;
                    }
                }
        ).build();
    }
}
