package ru.yandex.msearch.proxy.logger;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.logger.SystemErrManager;

public class Logger
{
    private static java.util.logging.Logger logger = null;
    private static java.util.logging.Logger error = null;
    public static Logger StaticLogger = new Logger();
    public static PrefixedLogger prefixedLogger =
        new PrefixedLogger(
            java.util.logging.Logger.getAnonymousLogger(), "", " ");

    static {
        Handler handler = new Handler() {
            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }

            @Override
            public void publish(final LogRecord record) {
                Throwable t = record.getThrown();
                String message;
                if (t == null) {
                    message = record.getMessage();
                } else {
                    StringBuilderWriter sbw = new StringBuilderWriter();
                    sbw.append(record.getMessage());
                    sbw.append(':');
                    sbw.append('\n');
                    t.printStackTrace(sbw);
                    message = sbw.toString();
                }
                if (Level.SEVERE.equals(record.getLevel())) {
                    err(message);
                } else if (Level.WARNING.equals(record.getLevel())) {
                    warn(message);
                } else if (Level.INFO.equals(record.getLevel())) {
                    info(message);
                } else {
                    debug(message);
                }
            }
        };
        handler.setLevel(Level.ALL);
        prefixedLogger.addHandler(handler);
        prefixedLogger.setLevel(Level.ALL);
        prefixedLogger.setUseParentHandlers(false);
    }

    public static String exception(Throwable aThrowable) {
        StringBuilderWriter sbw = new StringBuilderWriter();
        aThrowable.printStackTrace(sbw);
        return sbw.toString();
    }

    public static void debug(String msg) {
        logger.fine(msg);
    }

    public static void info(String msg) {
        logger.info(msg);
    }

    public static void warn(String msg) {
        logger.warning(msg);
    }

    public static void err(String msg) {
        logger.severe(msg);
    }

    public synchronized static void init(
        java.util.logging.Logger fullLog,
        java.util.logging.Logger errorLog)
        throws Exception
    {
        System.err.println("MSProxy setting System.err");
        logger = fullLog;
        error = errorLog;
        SystemErrManager.setErr(error);
    }

    public static void deinit() {
        SystemErrManager.unsetErr();
    }

    static class LoggingOutputStream extends ByteArrayOutputStream {
        private String lineSeparator;
        private java.util.logging.Logger logger;

        public LoggingOutputStream(final java.util.logging.Logger logger) {
            this.logger = logger;
            lineSeparator = System.getProperty("line.separator");
        }

        public synchronized void flush() throws IOException
        {
            super.flush();
            String record = toString();
            reset();

            if (record.length() == 0 || record.equals(lineSeparator)) {
                // avoid empty records
                return;
            }
            logger.info(record);
        }
    }
}
