package ru.yandex.msearch.proxy.mail;

import java.util.List;
import java.util.Map;

import org.apache.http.client.*;
import org.apache.http.impl.client.*;
import org.apache.http.client.config.RequestConfig;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.api.chemodan.UserInfo;
import ru.yandex.msearch.proxy.httpclient.CommonHttpClient;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class FolderListFactory {
    private static HttpRequestRetryHandler httpRetryHandler =
        new DefaultHttpRequestRetryHandler(2, true);
    private static HttpClient httpClient;

    public static void init(final IniConfig config) throws ConfigException {
        JSONFolderList.init(config);
        RequestConfig rqConfig = RequestConfig.custom()
                .setSocketTimeout( 3000 )
                .setConnectTimeout( 2000 )
                .setExpectContinueEnabled( false )
                .setStaleConnectionCheckEnabled( false )
                .build();
        httpClient = CommonHttpClient.httpClientBuilder
                .setDefaultRequestConfig(rqConfig)
                .setRetryHandler( httpRetryHandler )
                .build();
    }



    public static FolderList create(
        final HttpServer.RequestContext ctx,
        final UserInfo userInfo)
    {
        return new JSONFolderList(ctx, userInfo);
    }

    public static HttpClient httpClient() {
        return httpClient;
    }

}
