package ru.yandex.msearch.proxy.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InputStream;

import org.apache.http.client.*;
import org.apache.http.impl.client.*;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.http.util.client.measurable.MeasurableHttpContext;

import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.JsonParser;

import ru.yandex.json.xpath.XPathContentHandler;
import ru.yandex.json.xpath.PathComponent;
import ru.yandex.json.xpath.PrimitiveHandler;

import ru.yandex.json.writer.JsonWriter;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.api.chemodan.UserInfo;
import ru.yandex.msearch.proxy.httpclient.CommonHttpClient;
import ru.yandex.msearch.proxy.logger.Logger;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class JSONFolderList implements FolderList
{
private static String WMI_FOLDER_LIST_URL;
private final HttpServer.RequestContext ctx;
private final UserInfo userInfo;

    public static void init(final IniConfig config) throws ConfigException {
        WMI_FOLDER_LIST_URL = config.getString("folder_list_url",
            "http://meta-qloud.mail.yandex.net:80/folders");
    }

    public JSONFolderList(
        final HttpServer.RequestContext ctx,
        final UserInfo userInfo)
    {
	this.ctx = ctx;
        this.userInfo = userInfo;
    }

    @Override
    public List<Map<String,String>> getFolders() throws MsearchProxyException {
	HttpEntity httpEntity = null;
	InputStream is = null;
	BufferedReader r = null;
	try {
	    long startTime = System.currentTimeMillis();

	    HttpGet httpGet = new HttpGet(
                WMI_FOLDER_LIST_URL
	        + "?suid=" + userInfo.getSuid()
                + "&uid=" + userInfo.getUid()
                + "&mdb=" + userInfo.getMailDb());

            String language = userInfo.getLanguage();
	    httpGet.setHeader("Accept-Language", language);
	    if (language.equalsIgnoreCase("en")) {
		httpGet.setHeader("User-Agent", "mail.yandex.com"); //FixMe: What an ugly hack!!!
	    }
	    ctx.log.info(
                "JSONFolderList: going to get folders from: " + httpGet);

            MeasurableHttpContext context = new MeasurableHttpContext();
            HttpResponse response =
                FolderListFactory.httpClient().execute(httpGet, context);
            ctx.log.info(context.finAndGetInfo());
	    httpEntity = response.getEntity();

	    ctx.log.info("JSONFolderList.getFolders status: " +
	        response.getStatusLine());

	    if (httpEntity != null) {
		if (
		    response.getStatusLine().getStatusCode() < 200 ||
		    response.getStatusLine().getStatusCode() >= 400)
		{
		    ctx.log.err( "JSONFolderList: getFolders error: " +
		        "server returned status: " +
		        response.getStatusLine().getStatusCode());
		    is = httpEntity.getContent();
		    r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
		    String line;
		    while ((line = r.readLine()) != null) {
			ctx.log.err("JSONFolderList.getFolders error: server response: " + line);
		    }
		}
                is = httpEntity.getContent();
	        r = new BufferedReader(new InputStreamReader( is, "UTF-8" ));
	        ctx.log.info("JSONFolderList: folders received in <" +
	            (System.currentTimeMillis() - startTime) + "> ms");
	        return readFoldersJson(r);
	    } else {
	        throw new MsearchProxyException("JSONFolderList: server empty response");
	    }
	} catch(IOException e) {
	    throw new MsearchProxyException(e);
	} finally {
	    try {
		if( is != null) is.close();
		if( r != null ) r.close();
	    } catch( IOException e ) {
		ctx.log.err("JSONFolderList: exception in getFolders: " +
		    Logger.exception(e)); 
	    }
	}
    }

    private List<Map<String,String>> readFoldersJson(BufferedReader r)
        throws MsearchProxyException
    {
	try {
	    final FoldersJsonHandler foldersHandler = new FoldersJsonHandler();
            XPathContentHandler jsonHandler =
                new XPathContentHandler(foldersHandler) {
                    @Override
                    public void endObject() throws JsonException {
                        foldersHandler.endObject();
                        super.endObject();
                    }
                };

            JsonParser jsonParser = new JsonParser(jsonHandler);
            jsonParser.parse(r);
            return foldersHandler.folderList();
	} catch(IOException|JsonException e) {
	    ctx.log.err("JSONFolderList parse error: " + e.toString());
	    throw new MsearchProxyException(e);
	}
    }

    public class FoldersJsonHandler implements PrimitiveHandler {
        private Map<String,String> folder = null;
        private List<Map<String,String>> folders =
            new ArrayList<Map<String,String>>();
        private int level = 0;

        public List<Map<String,String>> folderList() {
            return folders;
        }

        @Override
        public void handle(final List<PathComponent> path,
            final Object value)
    //        throws JsonException
        {
//JSON:
//{
//  "folders": {
//      "2170000110000004455": {
//            "name": "Inbox",
//        }
//    }

            if (path.size() == 3) {
                if (path.get(0).name() != null &&
                    path.get(0).name().equals("folders"))
                {
                    level = 3;
                    String fid = path.get(1).name();
                    if (fid == null) {
                        //Invalid fid
                        return;
                    }
                    if (folder == null) {
                        folder = new HashMap<String,String>();
                        folder.put("id", fid);
                    }
                    String attr = path.get(2).name();
                    if (attr == null) {
                        return;
                    }
                    if (value == null) {
                        return;
                    }
                    folder.put(attr, value.toString());
                }
            } else if (path.size() == 4) {
                level = 4;
                String attr = path.get(2).name();
                if (attr == null) {
                    return;
                }
                if (attr.equals("symbolicName")) {
                    String subAttr = path.get(3).name();
                    if (subAttr == null || value == null) {
                        return;
                    }
                    if (subAttr.equals("title") && folder != null) {
                        folder.put(attr, value.toString());
                    }
                }
            }
        }

        public void endObject() {
            if (level-- != 3) {
                return;
            }
            if (folder == null) {
                return;
            }

	    String system = folder.get("symbolicName");
	    if (system != null && system.length() != 0) {
	        folder.put("systemFolder", "true");
	        folder.put("symbol", system);
	    }
	    String name = folder.get("name");
	    if (name.contains("|")) {
		name = name.substring(name.lastIndexOf('|') + 1);
		folder.put("name", name);
	    }
	    String parentId = folder.get("parentId");
	    if (parentId != null && !parentId.equals("0")) {
	        folder.put("parent_id", parentId);
	    }

            folders.add(folder);
            folder = null;
        }

    }
}
