package ru.yandex.msearch.proxy.mail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import java.util.Map;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.client.wmi.Labels;

public class SearchFilter {
    private static final String HAMON = "hamon.lid";

    private static final Pattern PATTERN =
        Pattern.compile("\\$\\{user\\.([a-z\\.A-Z]+)\\}");

    private final List<Part> parts = new ArrayList<>();

    public SearchFilter(final String filter) {
        Matcher matcher = PATTERN.matcher(filter);
        int last = 0;

        while(matcher.find()) {
            parts.add(new SimplePart(filter.substring(last, matcher.start())));
            parts.add(new DictPart(matcher.group(1)));
            last = matcher.end();
        }

        if (last < filter.length()) {
            parts.add(new SimplePart(filter.substring(last, filter.length())));
        }
    }

    public String apply(final Labels labels) {
        StringBuilder sb = new StringBuilder();
        apply(sb, labels);
        return sb.toString();
    }

    public void apply(final StringBuilder sb, final Labels labels) {
        if (parts.size() == 1) {
            parts.get(0).add(sb, Collections.emptyMap());
            return;
        }

        Map<String, String> dict = new HashMap<>();
        dict.put(HAMON, String.valueOf(labels.hamonLid()));

        for (Part part: parts) {
            part.add(sb, dict);
        }
    }

    private abstract class Part {
        protected final String s;

        public Part(final String s) {
            this.s = s;
        }

        abstract void add(
            final StringBuilder sb,
            final Map<String, String> dict);
    }

    private class SimplePart extends Part {
        public SimplePart(final String s) {
            super(s);
        }

        @Override
        public void add(
            final StringBuilder sb,
            final Map<String, String> dict)
        {
            sb.append(s);
        }
    }

    private class DictPart extends Part {
        public DictPart(final String name) {
            super(name);
        }

        @Override
        public void add(
            final StringBuilder sb,
            final Map<String, String> dict)
        {
            sb.append(dict.get(s));
        }
    }
}
