package ru.yandex.msearch.proxy.ora;

import java.io.IOException;
import java.io.Reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

import ru.yandex.http.util.CharsetUtils;

import ru.yandex.json.parser.JsonException;
import ru.yandex.json.xpath.ValueUtils;

import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.collector.Collector;
import ru.yandex.msearch.proxy.document.Document;

public abstract class AbstractFilterSearch implements FilterSearch {
    protected static final String BATCH_SIZE = "&batch-size=30000";

    private final String sessionId;
    private final FieldRenamer renamer;

    protected Set<String> mids;
    protected String mailDb = new String();
    private int found = 0;

    protected AbstractFilterSearch(
        final String sessionId,
        final Map<String, String> renamer)
    {
        this.sessionId = sessionId;
        this.renamer = new MapFieldRenamer(renamer);
    }

    protected AbstractFilterSearch(
        final String sessionId,
        final Set<String> renamer)
    {
        this.sessionId = sessionId;
        this.renamer = new SetFieldRenamer(renamer);
    }

    @Override
    public void setHistoryMode(final boolean historyMode) {
    }

    @Override
    public void setUnread(final boolean unread) {
    }

    @Override
    public void setOnlyAttachments(final boolean onlyAttachments) {
    }

    @Override
    public void setExcludeSpam(final boolean excludeSpam) {
    }

    @Override
    public void setExcludeTrash(final boolean excludeTrash) {
    }

    @Override
    public void setFids(final List<String> fids) {
    }

    @Override
    public void setMids(final Set<String> mids) {
        this.mids = mids;
    }

    @Override
    public void setLids(final List<String> lids) {
    }

    @Override
    public void setSuid(final String suid) {
    }

    @Override
    public void setMailDb(final String mailDb) {
        this.mailDb = mailDb;
    }

    @Override
    public void setFolderSet(final String folderSet) {
    }

    @Override
    public void setOrder(final String order) {
    }
}
