package ru.yandex.msearch.proxy.ora;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpException;
import org.apache.http.client.*;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.*;
import org.apache.http.message.BasicHeader;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.client.ClientBuilder;
import ru.yandex.http.util.client.measurable.MeasurableHttpContext;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.JsonParser;
import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.msearch.proxy.collector.Collector;
import ru.yandex.msearch.proxy.config.ImmutableMsearchProxyConfig;
import ru.yandex.msearch.proxy.document.Document;
import ru.yandex.msearch.proxy.httpclient.CommonHttpClient;
import ru.yandex.msearch.proxy.ora.wmi.json.RootHandler;
import ru.yandex.msearch.proxy.ora.wmi.json.WmiJsonHandlersManager;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class WmiFilterSearchClient implements FilterSearch
{
private String sessionId;
private boolean historyMode;
private boolean unread = false;
private boolean onlyAttachments = false;
private boolean excludeSpam = false;
private boolean excludeTrash = false;
private List<String> fids = new LinkedList<String>();
private Set<String> mids;
private List<String> lids = new LinkedList<String>();
private String suid = new String();
private String mailDb = new String();
private String folderSet = new String();
private String order = new String();
private static String WMI_FILTER_SEARCH_URL;
private static String WMI_CORP_FILTER_SEARCH_URL;
private final HttpServer.RequestContext ctx;

private static CloseableHttpClient httpClient;

    public static void initHttpClient() {
        RequestConfig config = RequestConfig.custom()
                .setSocketTimeout( 10000 )
                .setConnectTimeout( 2000 )
                .setExpectContinueEnabled( false )
                .setStaleConnectionCheckEnabled( false )
                .build();
        httpClient = CommonHttpClient.httpClientBuilder
                .setDefaultRequestConfig(config)
                .setRetryHandler( new DefaultHttpRequestRetryHandler( 2, true ) )
                .build();
    }

    public static void init(final ImmutableMsearchProxyConfig config)
        throws ConfigException
    {
        WMI_FILTER_SEARCH_URL = config.filterSearchConfig().uri().toString();
        WMI_CORP_FILTER_SEARCH_URL =
            config.corpFilterSearchConfig().uri().toString();
        initHttpClient();
    }

    private static class HttpArguments
    {
    private Map<String, List<String> > args = new HashMap<String, List<String> >();

	public List<String> arguments( String key )
	{
	    List<String> arg = args.get(key);
	    if( arg == null )
	    {
		arg = new LinkedList<String>();
		args.put( key, arg );
	    }
	    return arg;
	}

	private String encode( String in )
	{
	    try
	    {
		URLEncoder.encode( in, "UTF-8");
	    }
	    catch( Exception e ){};
	    return in;
	}

	@Override
	public String toString()
	{
	    StringBuilder sb = new StringBuilder();
	    Iterator<Map.Entry<String, List<String> >> iter = args.entrySet().iterator();
	    boolean first = true;
	    while( iter.hasNext() )
	    {
		Map.Entry<String, List<String>> entry = iter.next();

		Iterator<String> argIter = entry.getValue().iterator();

		while( argIter.hasNext() )
		{
		    if( first ) first = false;
		    else sb.append( "&" );
		    String value = argIter.next();
		    sb.append( encode( entry.getKey() ) );
		    sb.append( "=" );
		    sb.append( encode( value ) );
		}
	    }
	    return sb.toString();
	}
    }

    public WmiFilterSearchClient( String sessionId, HttpServer.RequestContext ctx )
    {
	this.sessionId = sessionId;
	this.ctx = ctx;
    }

    public void setHistoryMode( boolean historyMode )
    {
	this.historyMode = historyMode;
    }

    public void setFids( List<String> fids )
    {
	this.fids = fids;
    }

    public void setMids( Set<String> mids )
    {
	this.mids = mids;
    }

    public void setLids( List<String> lids )
    {
	this.lids = lids;
    }

    public void setUnread( boolean unread )
    {
	this.unread = unread;
    }

    public void setOnlyAttachments( boolean attachments )
    {
	this.onlyAttachments = attachments;
    }

    @Override
    public void setExcludeSpam(final boolean excludeSpam) {
        this.excludeSpam = excludeSpam;
    }

    @Override
    public void setExcludeTrash(final boolean excludeTrash) {
        this.excludeTrash = excludeTrash;
    }

    public void setSuid( String suid )
    {
	this.suid = suid;
    }

    public void setMailDb( String mdb )
    {
	this.mailDb = mdb;
    }

    public void setFolderSet( String folderSet )
    {
	this.folderSet = folderSet;
    }

    public void setOrder( String order )
    {
	this.order = order;
    }

    private void makeRequest( HttpArguments args )
    {
	args.arguments(ProxyParams.MDB).add(mailDb );
	if (mailDb.equalsIgnoreCase(ProxyParams.PG)) {
            args.arguments(ProxyParams.UID).add( suid );
	} else {
            args.arguments(ProxyParams.SUID).add( suid );
        }
	args.arguments("mids").addAll( mids );

	if( historyMode )
	{
	    args.arguments("mode").add( "history" );
	}
	else
	{
	    args.arguments("order").add( order );
	    args.arguments("fids").addAll( fids );
	    args.arguments("lids").addAll( lids );

	    if( unread ) args.arguments("unread").add( "yes");
	    if( onlyAttachments ) args.arguments("only_attachments").add( "1");
	    if( !folderSet.isEmpty() ) args.arguments("folder_set").add( folderSet );
	}

        if (excludeSpam) {
            args.arguments("excl_folders").add("spam");
        }

        if (excludeTrash) {
            args.arguments("excl_folders").add("trash");
        }
    }

    private int requestData( Map<String, Document> toFilter, Collector collector, HttpServer.RequestContext ctx ) throws IOException
    {
	HttpArguments args = new HttpArguments();
	makeRequest( args );
	try {
            String filterSearchUrl;
            if (BlackboxUserinfo.corp(Long.parseLong(suid))) {
                filterSearchUrl = WMI_CORP_FILTER_SEARCH_URL;
            } else {
                filterSearchUrl = WMI_FILTER_SEARCH_URL;
            }
	    HttpPost httpPost = new HttpPost(filterSearchUrl);
            String body = args.toString();
            httpPost.setEntity(
                new StringEntity(
                    body,
                    ContentType.APPLICATION_FORM_URLENCODED));
            httpPost.addHeader(new BasicHeader(YandexHeaders.X_YA_SERVICE_TICKET,
                ctx.server()
                    .filterSearchTvm2Ticket(
                        BlackboxUserinfo.corp(Long.parseLong(suid)
                        )
                    )
            ));
        ctx.log.debug(
                "requesting " + httpPost.getRequestLine()
                + " with body: " + body);
	    MeasurableHttpContext context = new MeasurableHttpContext();
	    try (CloseableHttpResponse response =
                    httpClient.execute(httpPost, context))
            {
                ctx.log.info(context.finAndGetInfo());
                return readData(
                    CharsetUtils.content(response.getEntity()),
                    toFilter,
                    collector);
            } catch (HttpException e) {
                throw new IOException("Bad response", e);
            }
	} catch(FileNotFoundException fe) {
	    ctx.log.err("filter_search request failed: Server returned HTTP response code: 404 for URL: " + WMI_FILTER_SEARCH_URL);
	    throw fe;
	} catch(IOException e) {
	    ctx.log.err("filter_search request failed", e);
	    throw e;
	}
    }

    private int readData( Reader r, Map<String, Document> toFilter, Collector collector ) throws IOException
    {
        try (Reader reader = r) {
            WmiJsonHandlersManager manager = new WmiJsonHandlersManager(toFilter);
            manager.push(new RootHandler(manager, collector));
            JsonParser parser = new JsonParser(manager);
            parser.parse(reader);
            return manager.found();
        } catch (JsonException e) {
            ctx.log.err("WmiFilterSearchClient JsonParser error", e);
            throw new IOException("Failed to parse /filter_search response", e);
        }
    }

    @Override
    public int filter( Map<String, Document> toFilter, Collector collector )
        throws MsearchProxyException
    {
        setMids( toFilter.keySet() );
        checkRequiredParams();

        int found;
        try {
            found = requestData( toFilter, collector, ctx );
        } catch (IOException ie) {
            throw new MsearchProxyException("WmiFilterSearch failed", ie);
        }
        return found;
    }

    private void checkRequiredParams() throws MsearchProxyException
    {
	if( mids.isEmpty() ) throw new MsearchProxyException( "missing param mids" );
	if( mailDb.isEmpty() ) throw new MsearchProxyException( "missing param mdb" );
    }
}

