package ru.yandex.msearch.proxy.ora.wmi.fields;

public class WmiField {
    public static final String ENVELOPES = "envelopes";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String CC = "cc";
    public static final String BCC = "bcc";
    public static final String REPLY_TO = "replyTo";
    public static final String EMAIL_DOMAIN = "domain";
    public static final String EMAIL_LOCAL = "local";
    public static final String EMAIL_DISPLAY = "displayName";
    public static final String LABELS = "labels";
    public static final String SPECIAL_LABELS = "specialLabels";
    public static final String TYPES = "types";
    public static final String ATTACHMENTS = "attachments";

    public static String constructEmail(
        final String domain,
        final String local,
        String display)
    {
        StringBuilder sb = new StringBuilder(
            display.length()
            + local.length()
            + domain.length()
            + 6);
        if (!display.isEmpty()) {
            sb.append('"');
            if (display.indexOf('\\') != -1) {
                display = display.replace("\\", "\\\\");
            }
            if (display.indexOf('"') != -1) {
                display = display.replace("\"", "\\\"");
            }
            sb.append(display);
            sb.append('"');
            sb.append(' ');
        }
        sb.append('<');
        sb.append(local);
        sb.append('@');
        sb.append(domain);
        sb.append('>');
        return new String(sb);
    }
}

