package ru.yandex.msearch.proxy.ora.wmi.json;

import ru.yandex.json.parser.JsonException;

import ru.yandex.msearch.proxy.collector.Collector;
import ru.yandex.msearch.proxy.ora.wmi.fields.WmiField;

import ru.yandex.search.json.KeyCollectingHandler;

public class BodyHandler extends KeyCollectingHandler {
    private final WmiJsonHandlersManager manager;
    private final Collector collector;

    public BodyHandler(
        final WmiJsonHandlersManager manager,
        final Collector collector)
    {
        super(manager);
        this.manager = manager;
        this.collector = collector;
    }

    @Override
    public void key(final String key) throws JsonException {
        if (key.equals(WmiField.ENVELOPES)) {
            manager.push(new EnvelopesHandler(manager, collector));
        } else {
            throw new JsonException("Unexpected key '" + key + '\'');
        }
    }

    @Override
    public void endObject() {
        manager.pop();
    }
}
