package ru.yandex.msearch.proxy.ora.wmi.json;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.json.parser.BadContentHandler;

import ru.yandex.msearch.proxy.document.Document;

import ru.yandex.search.json.HandlersManager;

public class EmailArrayHandler extends BadContentHandler {
    private final List<String> emails = new ArrayList<>();
    private final HandlersManager manager;
    private final String key;
    private final Document doc;

    public EmailArrayHandler(
        final HandlersManager manager,
        final String key,
        final Document doc)
    {
        this.manager = manager;
        this.key = key;
        this.doc = doc;
    }

    @Override
    public void startObject(){
        manager.push(new EmailHandler(manager, emails));
    }

    @Override
    public void endArray() {
        String value = StringUtils.join(emails, ',');
        doc.setAttr(key, value);
        manager.pop();
    }
}

